/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchRequest;
import software.amazon.awssdk.services.cloudwatch.model.ComparisonOperator;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.DimensionsCopier;
import software.amazon.awssdk.services.cloudwatch.model.MetricDataQueriesCopier;
import software.amazon.awssdk.services.cloudwatch.model.MetricDataQuery;
import software.amazon.awssdk.services.cloudwatch.model.ResourceListCopier;
import software.amazon.awssdk.services.cloudwatch.model.StandardUnit;
import software.amazon.awssdk.services.cloudwatch.model.Statistic;
import software.amazon.awssdk.services.cloudwatch.model.Tag;
import software.amazon.awssdk.services.cloudwatch.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutMetricAlarmRequest
extends CloudWatchRequest
implements ToCopyableBuilder<Builder, PutMetricAlarmRequest> {
    private static final SdkField<String> ALARM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlarmName").getter(PutMetricAlarmRequest.getter(PutMetricAlarmRequest::alarmName)).setter(PutMetricAlarmRequest.setter(Builder::alarmName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmName").build()}).build();
    private static final SdkField<String> ALARM_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlarmDescription").getter(PutMetricAlarmRequest.getter(PutMetricAlarmRequest::alarmDescription)).setter(PutMetricAlarmRequest.setter(Builder::alarmDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmDescription").build()}).build();
    private static final SdkField<Boolean> ACTIONS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ActionsEnabled").getter(PutMetricAlarmRequest.getter(PutMetricAlarmRequest::actionsEnabled)).setter(PutMetricAlarmRequest.setter(Builder::actionsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionsEnabled").build()}).build();
    private static final SdkField<List<String>> OK_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OKActions").getter(PutMetricAlarmRequest.getter(PutMetricAlarmRequest::okActions)).setter(PutMetricAlarmRequest.setter(Builder::okActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OKActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ALARM_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AlarmActions").getter(PutMetricAlarmRequest.getter(PutMetricAlarmRequest::alarmActions)).setter(PutMetricAlarmRequest.setter(Builder::alarmActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INSUFFICIENT_DATA_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InsufficientDataActions").getter(PutMetricAlarmRequest.getter(PutMetricAlarmRequest::insufficientDataActions)).setter(PutMetricAlarmRequest.setter(Builder::insufficientDataActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsufficientDataActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricName").getter(PutMetricAlarmRequest.getter(PutMetricAlarmRequest::metricName)).setter(PutMetricAlarmRequest.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Namespace").getter(PutMetricAlarmRequest.getter(PutMetricAlarmRequest::namespace)).setter(PutMetricAlarmRequest.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()}).build();
    private static final SdkField<String> STATISTIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Statistic").getter(PutMetricAlarmRequest.getter(PutMetricAlarmRequest::statisticAsString)).setter(PutMetricAlarmRequest.setter(Builder::statistic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statistic").build()}).build();
    private static final SdkField<String> EXTENDED_STATISTIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExtendedStatistic").getter(PutMetricAlarmRequest.getter(PutMetricAlarmRequest::extendedStatistic)).setter(PutMetricAlarmRequest.setter(Builder::extendedStatistic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtendedStatistic").build()}).build();
    private static final SdkField<List<Dimension>> DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Dimensions").getter(PutMetricAlarmRequest.getter(PutMetricAlarmRequest::dimensions)).setter(PutMetricAlarmRequest.setter(Builder::dimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Dimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Period").getter(PutMetricAlarmRequest.getter(PutMetricAlarmRequest::period)).setter(PutMetricAlarmRequest.setter(Builder::period)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Period").build()}).build();
    private static final SdkField<String> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Unit").getter(PutMetricAlarmRequest.getter(PutMetricAlarmRequest::unitAsString)).setter(PutMetricAlarmRequest.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()}).build();
    private static final SdkField<Integer> EVALUATION_PERIODS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EvaluationPeriods").getter(PutMetricAlarmRequest.getter(PutMetricAlarmRequest::evaluationPeriods)).setter(PutMetricAlarmRequest.setter(Builder::evaluationPeriods)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationPeriods").build()}).build();
    private static final SdkField<Integer> DATAPOINTS_TO_ALARM_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DatapointsToAlarm").getter(PutMetricAlarmRequest.getter(PutMetricAlarmRequest::datapointsToAlarm)).setter(PutMetricAlarmRequest.setter(Builder::datapointsToAlarm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatapointsToAlarm").build()}).build();
    private static final SdkField<Double> THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Threshold").getter(PutMetricAlarmRequest.getter(PutMetricAlarmRequest::threshold)).setter(PutMetricAlarmRequest.setter(Builder::threshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Threshold").build()}).build();
    private static final SdkField<String> COMPARISON_OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComparisonOperator").getter(PutMetricAlarmRequest.getter(PutMetricAlarmRequest::comparisonOperatorAsString)).setter(PutMetricAlarmRequest.setter(Builder::comparisonOperator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparisonOperator").build()}).build();
    private static final SdkField<String> TREAT_MISSING_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TreatMissingData").getter(PutMetricAlarmRequest.getter(PutMetricAlarmRequest::treatMissingData)).setter(PutMetricAlarmRequest.setter(Builder::treatMissingData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TreatMissingData").build()}).build();
    private static final SdkField<String> EVALUATE_LOW_SAMPLE_COUNT_PERCENTILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluateLowSampleCountPercentile").getter(PutMetricAlarmRequest.getter(PutMetricAlarmRequest::evaluateLowSampleCountPercentile)).setter(PutMetricAlarmRequest.setter(Builder::evaluateLowSampleCountPercentile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluateLowSampleCountPercentile").build()}).build();
    private static final SdkField<List<MetricDataQuery>> METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Metrics").getter(PutMetricAlarmRequest.getter(PutMetricAlarmRequest::metrics)).setter(PutMetricAlarmRequest.setter(Builder::metrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricDataQuery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(PutMetricAlarmRequest.getter(PutMetricAlarmRequest::tags)).setter(PutMetricAlarmRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> THRESHOLD_METRIC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ThresholdMetricId").getter(PutMetricAlarmRequest.getter(PutMetricAlarmRequest::thresholdMetricId)).setter(PutMetricAlarmRequest.setter(Builder::thresholdMetricId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThresholdMetricId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARM_NAME_FIELD, ALARM_DESCRIPTION_FIELD, ACTIONS_ENABLED_FIELD, OK_ACTIONS_FIELD, ALARM_ACTIONS_FIELD, INSUFFICIENT_DATA_ACTIONS_FIELD, METRIC_NAME_FIELD, NAMESPACE_FIELD, STATISTIC_FIELD, EXTENDED_STATISTIC_FIELD, DIMENSIONS_FIELD, PERIOD_FIELD, UNIT_FIELD, EVALUATION_PERIODS_FIELD, DATAPOINTS_TO_ALARM_FIELD, THRESHOLD_FIELD, COMPARISON_OPERATOR_FIELD, TREAT_MISSING_DATA_FIELD, EVALUATE_LOW_SAMPLE_COUNT_PERCENTILE_FIELD, METRICS_FIELD, TAGS_FIELD, THRESHOLD_METRIC_ID_FIELD));
    private final String alarmName;
    private final String alarmDescription;
    private final Boolean actionsEnabled;
    private final List<String> okActions;
    private final List<String> alarmActions;
    private final List<String> insufficientDataActions;
    private final String metricName;
    private final String namespace;
    private final String statistic;
    private final String extendedStatistic;
    private final List<Dimension> dimensions;
    private final Integer period;
    private final String unit;
    private final Integer evaluationPeriods;
    private final Integer datapointsToAlarm;
    private final Double threshold;
    private final String comparisonOperator;
    private final String treatMissingData;
    private final String evaluateLowSampleCountPercentile;
    private final List<MetricDataQuery> metrics;
    private final List<Tag> tags;
    private final String thresholdMetricId;

    private PutMetricAlarmRequest(BuilderImpl builder) {
        super(builder);
        this.alarmName = builder.alarmName;
        this.alarmDescription = builder.alarmDescription;
        this.actionsEnabled = builder.actionsEnabled;
        this.okActions = builder.okActions;
        this.alarmActions = builder.alarmActions;
        this.insufficientDataActions = builder.insufficientDataActions;
        this.metricName = builder.metricName;
        this.namespace = builder.namespace;
        this.statistic = builder.statistic;
        this.extendedStatistic = builder.extendedStatistic;
        this.dimensions = builder.dimensions;
        this.period = builder.period;
        this.unit = builder.unit;
        this.evaluationPeriods = builder.evaluationPeriods;
        this.datapointsToAlarm = builder.datapointsToAlarm;
        this.threshold = builder.threshold;
        this.comparisonOperator = builder.comparisonOperator;
        this.treatMissingData = builder.treatMissingData;
        this.evaluateLowSampleCountPercentile = builder.evaluateLowSampleCountPercentile;
        this.metrics = builder.metrics;
        this.tags = builder.tags;
        this.thresholdMetricId = builder.thresholdMetricId;
    }

    public final String alarmName() {
        return this.alarmName;
    }

    public final String alarmDescription() {
        return this.alarmDescription;
    }

    public final Boolean actionsEnabled() {
        return this.actionsEnabled;
    }

    public final boolean hasOkActions() {
        return this.okActions != null && !(this.okActions instanceof SdkAutoConstructList);
    }

    public final List<String> okActions() {
        return this.okActions;
    }

    public final boolean hasAlarmActions() {
        return this.alarmActions != null && !(this.alarmActions instanceof SdkAutoConstructList);
    }

    public final List<String> alarmActions() {
        return this.alarmActions;
    }

    public final boolean hasInsufficientDataActions() {
        return this.insufficientDataActions != null && !(this.insufficientDataActions instanceof SdkAutoConstructList);
    }

    public final List<String> insufficientDataActions() {
        return this.insufficientDataActions;
    }

    public final String metricName() {
        return this.metricName;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final Statistic statistic() {
        return Statistic.fromValue(this.statistic);
    }

    public final String statisticAsString() {
        return this.statistic;
    }

    public final String extendedStatistic() {
        return this.extendedStatistic;
    }

    public final boolean hasDimensions() {
        return this.dimensions != null && !(this.dimensions instanceof SdkAutoConstructList);
    }

    public final List<Dimension> dimensions() {
        return this.dimensions;
    }

    public final Integer period() {
        return this.period;
    }

    public final StandardUnit unit() {
        return StandardUnit.fromValue(this.unit);
    }

    public final String unitAsString() {
        return this.unit;
    }

    public final Integer evaluationPeriods() {
        return this.evaluationPeriods;
    }

    public final Integer datapointsToAlarm() {
        return this.datapointsToAlarm;
    }

    public final Double threshold() {
        return this.threshold;
    }

    public final ComparisonOperator comparisonOperator() {
        return ComparisonOperator.fromValue(this.comparisonOperator);
    }

    public final String comparisonOperatorAsString() {
        return this.comparisonOperator;
    }

    public final String treatMissingData() {
        return this.treatMissingData;
    }

    public final String evaluateLowSampleCountPercentile() {
        return this.evaluateLowSampleCountPercentile;
    }

    public final boolean hasMetrics() {
        return this.metrics != null && !(this.metrics instanceof SdkAutoConstructList);
    }

    public final List<MetricDataQuery> metrics() {
        return this.metrics;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String thresholdMetricId() {
        return this.thresholdMetricId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmName());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOkActions() ? this.okActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAlarmActions() ? this.alarmActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInsufficientDataActions() ? this.insufficientDataActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.statisticAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.extendedStatistic());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDimensions() ? this.dimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.period());
        hashCode = 31 * hashCode + Objects.hashCode(this.unitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationPeriods());
        hashCode = 31 * hashCode + Objects.hashCode(this.datapointsToAlarm());
        hashCode = 31 * hashCode + Objects.hashCode(this.threshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.comparisonOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.treatMissingData());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluateLowSampleCountPercentile());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetrics() ? this.metrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.thresholdMetricId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutMetricAlarmRequest)) {
            return false;
        }
        PutMetricAlarmRequest other = (PutMetricAlarmRequest)((Object)obj);
        return Objects.equals(this.alarmName(), other.alarmName()) && Objects.equals(this.alarmDescription(), other.alarmDescription()) && Objects.equals(this.actionsEnabled(), other.actionsEnabled()) && this.hasOkActions() == other.hasOkActions() && Objects.equals(this.okActions(), other.okActions()) && this.hasAlarmActions() == other.hasAlarmActions() && Objects.equals(this.alarmActions(), other.alarmActions()) && this.hasInsufficientDataActions() == other.hasInsufficientDataActions() && Objects.equals(this.insufficientDataActions(), other.insufficientDataActions()) && Objects.equals(this.metricName(), other.metricName()) && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.statisticAsString(), other.statisticAsString()) && Objects.equals(this.extendedStatistic(), other.extendedStatistic()) && this.hasDimensions() == other.hasDimensions() && Objects.equals(this.dimensions(), other.dimensions()) && Objects.equals(this.period(), other.period()) && Objects.equals(this.unitAsString(), other.unitAsString()) && Objects.equals(this.evaluationPeriods(), other.evaluationPeriods()) && Objects.equals(this.datapointsToAlarm(), other.datapointsToAlarm()) && Objects.equals(this.threshold(), other.threshold()) && Objects.equals(this.comparisonOperatorAsString(), other.comparisonOperatorAsString()) && Objects.equals(this.treatMissingData(), other.treatMissingData()) && Objects.equals(this.evaluateLowSampleCountPercentile(), other.evaluateLowSampleCountPercentile()) && this.hasMetrics() == other.hasMetrics() && Objects.equals(this.metrics(), other.metrics()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.thresholdMetricId(), other.thresholdMetricId());
    }

    public final String toString() {
        return ToString.builder((String)"PutMetricAlarmRequest").add("AlarmName", (Object)this.alarmName()).add("AlarmDescription", (Object)this.alarmDescription()).add("ActionsEnabled", (Object)this.actionsEnabled()).add("OKActions", this.hasOkActions() ? this.okActions() : null).add("AlarmActions", this.hasAlarmActions() ? this.alarmActions() : null).add("InsufficientDataActions", this.hasInsufficientDataActions() ? this.insufficientDataActions() : null).add("MetricName", (Object)this.metricName()).add("Namespace", (Object)this.namespace()).add("Statistic", (Object)this.statisticAsString()).add("ExtendedStatistic", (Object)this.extendedStatistic()).add("Dimensions", this.hasDimensions() ? this.dimensions() : null).add("Period", (Object)this.period()).add("Unit", (Object)this.unitAsString()).add("EvaluationPeriods", (Object)this.evaluationPeriods()).add("DatapointsToAlarm", (Object)this.datapointsToAlarm()).add("Threshold", (Object)this.threshold()).add("ComparisonOperator", (Object)this.comparisonOperatorAsString()).add("TreatMissingData", (Object)this.treatMissingData()).add("EvaluateLowSampleCountPercentile", (Object)this.evaluateLowSampleCountPercentile()).add("Metrics", this.hasMetrics() ? this.metrics() : null).add("Tags", this.hasTags() ? this.tags() : null).add("ThresholdMetricId", (Object)this.thresholdMetricId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AlarmName": {
                return Optional.ofNullable(clazz.cast(this.alarmName()));
            }
            case "AlarmDescription": {
                return Optional.ofNullable(clazz.cast(this.alarmDescription()));
            }
            case "ActionsEnabled": {
                return Optional.ofNullable(clazz.cast(this.actionsEnabled()));
            }
            case "OKActions": {
                return Optional.ofNullable(clazz.cast(this.okActions()));
            }
            case "AlarmActions": {
                return Optional.ofNullable(clazz.cast(this.alarmActions()));
            }
            case "InsufficientDataActions": {
                return Optional.ofNullable(clazz.cast(this.insufficientDataActions()));
            }
            case "MetricName": {
                return Optional.ofNullable(clazz.cast(this.metricName()));
            }
            case "Namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "Statistic": {
                return Optional.ofNullable(clazz.cast(this.statisticAsString()));
            }
            case "ExtendedStatistic": {
                return Optional.ofNullable(clazz.cast(this.extendedStatistic()));
            }
            case "Dimensions": {
                return Optional.ofNullable(clazz.cast(this.dimensions()));
            }
            case "Period": {
                return Optional.ofNullable(clazz.cast(this.period()));
            }
            case "Unit": {
                return Optional.ofNullable(clazz.cast(this.unitAsString()));
            }
            case "EvaluationPeriods": {
                return Optional.ofNullable(clazz.cast(this.evaluationPeriods()));
            }
            case "DatapointsToAlarm": {
                return Optional.ofNullable(clazz.cast(this.datapointsToAlarm()));
            }
            case "Threshold": {
                return Optional.ofNullable(clazz.cast(this.threshold()));
            }
            case "ComparisonOperator": {
                return Optional.ofNullable(clazz.cast(this.comparisonOperatorAsString()));
            }
            case "TreatMissingData": {
                return Optional.ofNullable(clazz.cast(this.treatMissingData()));
            }
            case "EvaluateLowSampleCountPercentile": {
                return Optional.ofNullable(clazz.cast(this.evaluateLowSampleCountPercentile()));
            }
            case "Metrics": {
                return Optional.ofNullable(clazz.cast(this.metrics()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ThresholdMetricId": {
                return Optional.ofNullable(clazz.cast(this.thresholdMetricId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutMetricAlarmRequest, T> g) {
        return obj -> g.apply((PutMetricAlarmRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchRequest.BuilderImpl
    implements Builder {
        private String alarmName;
        private String alarmDescription;
        private Boolean actionsEnabled;
        private List<String> okActions = DefaultSdkAutoConstructList.getInstance();
        private List<String> alarmActions = DefaultSdkAutoConstructList.getInstance();
        private List<String> insufficientDataActions = DefaultSdkAutoConstructList.getInstance();
        private String metricName;
        private String namespace;
        private String statistic;
        private String extendedStatistic;
        private List<Dimension> dimensions = DefaultSdkAutoConstructList.getInstance();
        private Integer period;
        private String unit;
        private Integer evaluationPeriods;
        private Integer datapointsToAlarm;
        private Double threshold;
        private String comparisonOperator;
        private String treatMissingData;
        private String evaluateLowSampleCountPercentile;
        private List<MetricDataQuery> metrics = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String thresholdMetricId;

        private BuilderImpl() {
        }

        private BuilderImpl(PutMetricAlarmRequest model) {
            super(model);
            this.alarmName(model.alarmName);
            this.alarmDescription(model.alarmDescription);
            this.actionsEnabled(model.actionsEnabled);
            this.okActions(model.okActions);
            this.alarmActions(model.alarmActions);
            this.insufficientDataActions(model.insufficientDataActions);
            this.metricName(model.metricName);
            this.namespace(model.namespace);
            this.statistic(model.statistic);
            this.extendedStatistic(model.extendedStatistic);
            this.dimensions(model.dimensions);
            this.period(model.period);
            this.unit(model.unit);
            this.evaluationPeriods(model.evaluationPeriods);
            this.datapointsToAlarm(model.datapointsToAlarm);
            this.threshold(model.threshold);
            this.comparisonOperator(model.comparisonOperator);
            this.treatMissingData(model.treatMissingData);
            this.evaluateLowSampleCountPercentile(model.evaluateLowSampleCountPercentile);
            this.metrics(model.metrics);
            this.tags(model.tags);
            this.thresholdMetricId(model.thresholdMetricId);
        }

        public final String getAlarmName() {
            return this.alarmName;
        }

        public final void setAlarmName(String alarmName) {
            this.alarmName = alarmName;
        }

        @Override
        public final Builder alarmName(String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        public final String getAlarmDescription() {
            return this.alarmDescription;
        }

        public final void setAlarmDescription(String alarmDescription) {
            this.alarmDescription = alarmDescription;
        }

        @Override
        public final Builder alarmDescription(String alarmDescription) {
            this.alarmDescription = alarmDescription;
            return this;
        }

        public final Boolean getActionsEnabled() {
            return this.actionsEnabled;
        }

        public final void setActionsEnabled(Boolean actionsEnabled) {
            this.actionsEnabled = actionsEnabled;
        }

        @Override
        public final Builder actionsEnabled(Boolean actionsEnabled) {
            this.actionsEnabled = actionsEnabled;
            return this;
        }

        public final Collection<String> getOkActions() {
            if (this.okActions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.okActions;
        }

        public final void setOkActions(Collection<String> okActions) {
            this.okActions = ResourceListCopier.copy(okActions);
        }

        @Override
        public final Builder okActions(Collection<String> okActions) {
            this.okActions = ResourceListCopier.copy(okActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder okActions(String ... okActions) {
            this.okActions(Arrays.asList(okActions));
            return this;
        }

        public final Collection<String> getAlarmActions() {
            if (this.alarmActions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.alarmActions;
        }

        public final void setAlarmActions(Collection<String> alarmActions) {
            this.alarmActions = ResourceListCopier.copy(alarmActions);
        }

        @Override
        public final Builder alarmActions(Collection<String> alarmActions) {
            this.alarmActions = ResourceListCopier.copy(alarmActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmActions(String ... alarmActions) {
            this.alarmActions(Arrays.asList(alarmActions));
            return this;
        }

        public final Collection<String> getInsufficientDataActions() {
            if (this.insufficientDataActions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.insufficientDataActions;
        }

        public final void setInsufficientDataActions(Collection<String> insufficientDataActions) {
            this.insufficientDataActions = ResourceListCopier.copy(insufficientDataActions);
        }

        @Override
        public final Builder insufficientDataActions(Collection<String> insufficientDataActions) {
            this.insufficientDataActions = ResourceListCopier.copy(insufficientDataActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insufficientDataActions(String ... insufficientDataActions) {
            this.insufficientDataActions(Arrays.asList(insufficientDataActions));
            return this;
        }

        public final String getMetricName() {
            return this.metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getStatistic() {
            return this.statistic;
        }

        public final void setStatistic(String statistic) {
            this.statistic = statistic;
        }

        @Override
        public final Builder statistic(String statistic) {
            this.statistic = statistic;
            return this;
        }

        @Override
        public final Builder statistic(Statistic statistic) {
            this.statistic(statistic == null ? null : statistic.toString());
            return this;
        }

        public final String getExtendedStatistic() {
            return this.extendedStatistic;
        }

        public final void setExtendedStatistic(String extendedStatistic) {
            this.extendedStatistic = extendedStatistic;
        }

        @Override
        public final Builder extendedStatistic(String extendedStatistic) {
            this.extendedStatistic = extendedStatistic;
            return this;
        }

        public final List<Dimension.Builder> getDimensions() {
            List<Dimension.Builder> result = DimensionsCopier.copyToBuilder(this.dimensions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDimensions(Collection<Dimension.BuilderImpl> dimensions) {
            this.dimensions = DimensionsCopier.copyFromBuilder(dimensions);
        }

        @Override
        public final Builder dimensions(Collection<Dimension> dimensions) {
            this.dimensions = DimensionsCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Dimension ... dimensions) {
            this.dimensions(Arrays.asList(dimensions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Consumer<Dimension.Builder> ... dimensions) {
            this.dimensions(Stream.of(dimensions).map(c -> (Dimension)((Dimension.Builder)Dimension.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getPeriod() {
            return this.period;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final String getUnit() {
            return this.unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(StandardUnit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        public final Integer getEvaluationPeriods() {
            return this.evaluationPeriods;
        }

        public final void setEvaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
        }

        @Override
        public final Builder evaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
            return this;
        }

        public final Integer getDatapointsToAlarm() {
            return this.datapointsToAlarm;
        }

        public final void setDatapointsToAlarm(Integer datapointsToAlarm) {
            this.datapointsToAlarm = datapointsToAlarm;
        }

        @Override
        public final Builder datapointsToAlarm(Integer datapointsToAlarm) {
            this.datapointsToAlarm = datapointsToAlarm;
            return this;
        }

        public final Double getThreshold() {
            return this.threshold;
        }

        public final void setThreshold(Double threshold) {
            this.threshold = threshold;
        }

        @Override
        public final Builder threshold(Double threshold) {
            this.threshold = threshold;
            return this;
        }

        public final String getComparisonOperator() {
            return this.comparisonOperator;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        public final Builder comparisonOperator(ComparisonOperator comparisonOperator) {
            this.comparisonOperator(comparisonOperator == null ? null : comparisonOperator.toString());
            return this;
        }

        public final String getTreatMissingData() {
            return this.treatMissingData;
        }

        public final void setTreatMissingData(String treatMissingData) {
            this.treatMissingData = treatMissingData;
        }

        @Override
        public final Builder treatMissingData(String treatMissingData) {
            this.treatMissingData = treatMissingData;
            return this;
        }

        public final String getEvaluateLowSampleCountPercentile() {
            return this.evaluateLowSampleCountPercentile;
        }

        public final void setEvaluateLowSampleCountPercentile(String evaluateLowSampleCountPercentile) {
            this.evaluateLowSampleCountPercentile = evaluateLowSampleCountPercentile;
        }

        @Override
        public final Builder evaluateLowSampleCountPercentile(String evaluateLowSampleCountPercentile) {
            this.evaluateLowSampleCountPercentile = evaluateLowSampleCountPercentile;
            return this;
        }

        public final List<MetricDataQuery.Builder> getMetrics() {
            List<MetricDataQuery.Builder> result = MetricDataQueriesCopier.copyToBuilder(this.metrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetrics(Collection<MetricDataQuery.BuilderImpl> metrics) {
            this.metrics = MetricDataQueriesCopier.copyFromBuilder(metrics);
        }

        @Override
        public final Builder metrics(Collection<MetricDataQuery> metrics) {
            this.metrics = MetricDataQueriesCopier.copy(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(MetricDataQuery ... metrics) {
            this.metrics(Arrays.asList(metrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(Consumer<MetricDataQuery.Builder> ... metrics) {
            this.metrics(Stream.of(metrics).map(c -> (MetricDataQuery)((MetricDataQuery.Builder)MetricDataQuery.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getThresholdMetricId() {
            return this.thresholdMetricId;
        }

        public final void setThresholdMetricId(String thresholdMetricId) {
            this.thresholdMetricId = thresholdMetricId;
        }

        @Override
        public final Builder thresholdMetricId(String thresholdMetricId) {
            this.thresholdMetricId = thresholdMetricId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutMetricAlarmRequest build() {
            return new PutMetricAlarmRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutMetricAlarmRequest> {
        public Builder alarmName(String var1);

        public Builder alarmDescription(String var1);

        public Builder actionsEnabled(Boolean var1);

        public Builder okActions(Collection<String> var1);

        public Builder okActions(String ... var1);

        public Builder alarmActions(Collection<String> var1);

        public Builder alarmActions(String ... var1);

        public Builder insufficientDataActions(Collection<String> var1);

        public Builder insufficientDataActions(String ... var1);

        public Builder metricName(String var1);

        public Builder namespace(String var1);

        public Builder statistic(String var1);

        public Builder statistic(Statistic var1);

        public Builder extendedStatistic(String var1);

        public Builder dimensions(Collection<Dimension> var1);

        public Builder dimensions(Dimension ... var1);

        public Builder dimensions(Consumer<Dimension.Builder> ... var1);

        public Builder period(Integer var1);

        public Builder unit(String var1);

        public Builder unit(StandardUnit var1);

        public Builder evaluationPeriods(Integer var1);

        public Builder datapointsToAlarm(Integer var1);

        public Builder threshold(Double var1);

        public Builder comparisonOperator(String var1);

        public Builder comparisonOperator(ComparisonOperator var1);

        public Builder treatMissingData(String var1);

        public Builder evaluateLowSampleCountPercentile(String var1);

        public Builder metrics(Collection<MetricDataQuery> var1);

        public Builder metrics(MetricDataQuery ... var1);

        public Builder metrics(Consumer<MetricDataQuery.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder thresholdMetricId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

