/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatch.model.MetricDataQueriesCopier;
import software.amazon.awssdk.services.cloudwatch.model.MetricDataQuery;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricMathAnomalyDetector
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricMathAnomalyDetector> {
    private static final SdkField<List<MetricDataQuery>> METRIC_DATA_QUERIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricDataQueries").getter(MetricMathAnomalyDetector.getter(MetricMathAnomalyDetector::metricDataQueries)).setter(MetricMathAnomalyDetector.setter(Builder::metricDataQueries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricDataQueries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricDataQuery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_DATA_QUERIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<MetricDataQuery> metricDataQueries;

    private MetricMathAnomalyDetector(BuilderImpl builder) {
        this.metricDataQueries = builder.metricDataQueries;
    }

    public final boolean hasMetricDataQueries() {
        return this.metricDataQueries != null && !(this.metricDataQueries instanceof SdkAutoConstructList);
    }

    public final List<MetricDataQuery> metricDataQueries() {
        return this.metricDataQueries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricDataQueries() ? this.metricDataQueries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricMathAnomalyDetector)) {
            return false;
        }
        MetricMathAnomalyDetector other = (MetricMathAnomalyDetector)obj;
        return this.hasMetricDataQueries() == other.hasMetricDataQueries() && Objects.equals(this.metricDataQueries(), other.metricDataQueries());
    }

    public final String toString() {
        return ToString.builder((String)"MetricMathAnomalyDetector").add("MetricDataQueries", this.hasMetricDataQueries() ? this.metricDataQueries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetricDataQueries": {
                return Optional.ofNullable(clazz.cast(this.metricDataQueries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricMathAnomalyDetector, T> g) {
        return obj -> g.apply((MetricMathAnomalyDetector)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<MetricDataQuery> metricDataQueries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MetricMathAnomalyDetector model) {
            this.metricDataQueries(model.metricDataQueries);
        }

        public final List<MetricDataQuery.Builder> getMetricDataQueries() {
            List<MetricDataQuery.Builder> result = MetricDataQueriesCopier.copyToBuilder(this.metricDataQueries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricDataQueries(Collection<MetricDataQuery.BuilderImpl> metricDataQueries) {
            this.metricDataQueries = MetricDataQueriesCopier.copyFromBuilder(metricDataQueries);
        }

        @Override
        @Transient
        public final Builder metricDataQueries(Collection<MetricDataQuery> metricDataQueries) {
            this.metricDataQueries = MetricDataQueriesCopier.copy(metricDataQueries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder metricDataQueries(MetricDataQuery ... metricDataQueries) {
            this.metricDataQueries(Arrays.asList(metricDataQueries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder metricDataQueries(Consumer<MetricDataQuery.Builder> ... metricDataQueries) {
            this.metricDataQueries(Stream.of(metricDataQueries).map(c -> (MetricDataQuery)((MetricDataQuery.Builder)MetricDataQuery.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public MetricMathAnomalyDetector build() {
            return new MetricMathAnomalyDetector(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricMathAnomalyDetector> {
        public Builder metricDataQueries(Collection<MetricDataQuery> var1);

        public Builder metricDataQueries(MetricDataQuery ... var1);

        public Builder metricDataQueries(Consumer<MetricDataQuery.Builder> ... var1);
    }
}

