/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchRequest;
import software.amazon.awssdk.services.cloudwatch.model.ResourceListCopier;
import software.amazon.awssdk.services.cloudwatch.model.Tag;
import software.amazon.awssdk.services.cloudwatch.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutCompositeAlarmRequest
extends CloudWatchRequest
implements ToCopyableBuilder<Builder, PutCompositeAlarmRequest> {
    private static final SdkField<Boolean> ACTIONS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ActionsEnabled").getter(PutCompositeAlarmRequest.getter(PutCompositeAlarmRequest::actionsEnabled)).setter(PutCompositeAlarmRequest.setter(Builder::actionsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionsEnabled").build()}).build();
    private static final SdkField<List<String>> ALARM_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AlarmActions").getter(PutCompositeAlarmRequest.getter(PutCompositeAlarmRequest::alarmActions)).setter(PutCompositeAlarmRequest.setter(Builder::alarmActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ALARM_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlarmDescription").getter(PutCompositeAlarmRequest.getter(PutCompositeAlarmRequest::alarmDescription)).setter(PutCompositeAlarmRequest.setter(Builder::alarmDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmDescription").build()}).build();
    private static final SdkField<String> ALARM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlarmName").getter(PutCompositeAlarmRequest.getter(PutCompositeAlarmRequest::alarmName)).setter(PutCompositeAlarmRequest.setter(Builder::alarmName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmName").build()}).build();
    private static final SdkField<String> ALARM_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlarmRule").getter(PutCompositeAlarmRequest.getter(PutCompositeAlarmRequest::alarmRule)).setter(PutCompositeAlarmRequest.setter(Builder::alarmRule)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmRule").build()}).build();
    private static final SdkField<List<String>> INSUFFICIENT_DATA_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InsufficientDataActions").getter(PutCompositeAlarmRequest.getter(PutCompositeAlarmRequest::insufficientDataActions)).setter(PutCompositeAlarmRequest.setter(Builder::insufficientDataActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsufficientDataActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> OK_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OKActions").getter(PutCompositeAlarmRequest.getter(PutCompositeAlarmRequest::okActions)).setter(PutCompositeAlarmRequest.setter(Builder::okActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OKActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(PutCompositeAlarmRequest.getter(PutCompositeAlarmRequest::tags)).setter(PutCompositeAlarmRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIONS_ENABLED_FIELD, ALARM_ACTIONS_FIELD, ALARM_DESCRIPTION_FIELD, ALARM_NAME_FIELD, ALARM_RULE_FIELD, INSUFFICIENT_DATA_ACTIONS_FIELD, OK_ACTIONS_FIELD, TAGS_FIELD));
    private final Boolean actionsEnabled;
    private final List<String> alarmActions;
    private final String alarmDescription;
    private final String alarmName;
    private final String alarmRule;
    private final List<String> insufficientDataActions;
    private final List<String> okActions;
    private final List<Tag> tags;

    private PutCompositeAlarmRequest(BuilderImpl builder) {
        super(builder);
        this.actionsEnabled = builder.actionsEnabled;
        this.alarmActions = builder.alarmActions;
        this.alarmDescription = builder.alarmDescription;
        this.alarmName = builder.alarmName;
        this.alarmRule = builder.alarmRule;
        this.insufficientDataActions = builder.insufficientDataActions;
        this.okActions = builder.okActions;
        this.tags = builder.tags;
    }

    public Boolean actionsEnabled() {
        return this.actionsEnabled;
    }

    public boolean hasAlarmActions() {
        return this.alarmActions != null && !(this.alarmActions instanceof SdkAutoConstructList);
    }

    public List<String> alarmActions() {
        return this.alarmActions;
    }

    public String alarmDescription() {
        return this.alarmDescription;
    }

    public String alarmName() {
        return this.alarmName;
    }

    public String alarmRule() {
        return this.alarmRule;
    }

    public boolean hasInsufficientDataActions() {
        return this.insufficientDataActions != null && !(this.insufficientDataActions instanceof SdkAutoConstructList);
    }

    public List<String> insufficientDataActions() {
        return this.insufficientDataActions;
    }

    public boolean hasOkActions() {
        return this.okActions != null && !(this.okActions instanceof SdkAutoConstructList);
    }

    public List<String> okActions() {
        return this.okActions;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.actionsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmActions());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmName());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmRule());
        hashCode = 31 * hashCode + Objects.hashCode(this.insufficientDataActions());
        hashCode = 31 * hashCode + Objects.hashCode(this.okActions());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutCompositeAlarmRequest)) {
            return false;
        }
        PutCompositeAlarmRequest other = (PutCompositeAlarmRequest)((Object)obj);
        return Objects.equals(this.actionsEnabled(), other.actionsEnabled()) && Objects.equals(this.alarmActions(), other.alarmActions()) && Objects.equals(this.alarmDescription(), other.alarmDescription()) && Objects.equals(this.alarmName(), other.alarmName()) && Objects.equals(this.alarmRule(), other.alarmRule()) && Objects.equals(this.insufficientDataActions(), other.insufficientDataActions()) && Objects.equals(this.okActions(), other.okActions()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"PutCompositeAlarmRequest").add("ActionsEnabled", (Object)this.actionsEnabled()).add("AlarmActions", this.alarmActions()).add("AlarmDescription", (Object)this.alarmDescription()).add("AlarmName", (Object)this.alarmName()).add("AlarmRule", (Object)this.alarmRule()).add("InsufficientDataActions", this.insufficientDataActions()).add("OKActions", this.okActions()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActionsEnabled": {
                return Optional.ofNullable(clazz.cast(this.actionsEnabled()));
            }
            case "AlarmActions": {
                return Optional.ofNullable(clazz.cast(this.alarmActions()));
            }
            case "AlarmDescription": {
                return Optional.ofNullable(clazz.cast(this.alarmDescription()));
            }
            case "AlarmName": {
                return Optional.ofNullable(clazz.cast(this.alarmName()));
            }
            case "AlarmRule": {
                return Optional.ofNullable(clazz.cast(this.alarmRule()));
            }
            case "InsufficientDataActions": {
                return Optional.ofNullable(clazz.cast(this.insufficientDataActions()));
            }
            case "OKActions": {
                return Optional.ofNullable(clazz.cast(this.okActions()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutCompositeAlarmRequest, T> g) {
        return obj -> g.apply((PutCompositeAlarmRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchRequest.BuilderImpl
    implements Builder {
        private Boolean actionsEnabled;
        private List<String> alarmActions = DefaultSdkAutoConstructList.getInstance();
        private String alarmDescription;
        private String alarmName;
        private String alarmRule;
        private List<String> insufficientDataActions = DefaultSdkAutoConstructList.getInstance();
        private List<String> okActions = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutCompositeAlarmRequest model) {
            super(model);
            this.actionsEnabled(model.actionsEnabled);
            this.alarmActions(model.alarmActions);
            this.alarmDescription(model.alarmDescription);
            this.alarmName(model.alarmName);
            this.alarmRule(model.alarmRule);
            this.insufficientDataActions(model.insufficientDataActions);
            this.okActions(model.okActions);
            this.tags(model.tags);
        }

        public final Boolean getActionsEnabled() {
            return this.actionsEnabled;
        }

        @Override
        public final Builder actionsEnabled(Boolean actionsEnabled) {
            this.actionsEnabled = actionsEnabled;
            return this;
        }

        public final void setActionsEnabled(Boolean actionsEnabled) {
            this.actionsEnabled = actionsEnabled;
        }

        public final Collection<String> getAlarmActions() {
            return this.alarmActions;
        }

        @Override
        public final Builder alarmActions(Collection<String> alarmActions) {
            this.alarmActions = ResourceListCopier.copy(alarmActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmActions(String ... alarmActions) {
            this.alarmActions(Arrays.asList(alarmActions));
            return this;
        }

        public final void setAlarmActions(Collection<String> alarmActions) {
            this.alarmActions = ResourceListCopier.copy(alarmActions);
        }

        public final String getAlarmDescription() {
            return this.alarmDescription;
        }

        @Override
        public final Builder alarmDescription(String alarmDescription) {
            this.alarmDescription = alarmDescription;
            return this;
        }

        public final void setAlarmDescription(String alarmDescription) {
            this.alarmDescription = alarmDescription;
        }

        public final String getAlarmName() {
            return this.alarmName;
        }

        @Override
        public final Builder alarmName(String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        public final void setAlarmName(String alarmName) {
            this.alarmName = alarmName;
        }

        public final String getAlarmRule() {
            return this.alarmRule;
        }

        @Override
        public final Builder alarmRule(String alarmRule) {
            this.alarmRule = alarmRule;
            return this;
        }

        public final void setAlarmRule(String alarmRule) {
            this.alarmRule = alarmRule;
        }

        public final Collection<String> getInsufficientDataActions() {
            return this.insufficientDataActions;
        }

        @Override
        public final Builder insufficientDataActions(Collection<String> insufficientDataActions) {
            this.insufficientDataActions = ResourceListCopier.copy(insufficientDataActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insufficientDataActions(String ... insufficientDataActions) {
            this.insufficientDataActions(Arrays.asList(insufficientDataActions));
            return this;
        }

        public final void setInsufficientDataActions(Collection<String> insufficientDataActions) {
            this.insufficientDataActions = ResourceListCopier.copy(insufficientDataActions);
        }

        public final Collection<String> getOkActions() {
            return this.okActions;
        }

        @Override
        public final Builder okActions(Collection<String> okActions) {
            this.okActions = ResourceListCopier.copy(okActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder okActions(String ... okActions) {
            this.okActions(Arrays.asList(okActions));
            return this;
        }

        public final void setOkActions(Collection<String> okActions) {
            this.okActions = ResourceListCopier.copy(okActions);
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutCompositeAlarmRequest build() {
            return new PutCompositeAlarmRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutCompositeAlarmRequest> {
        public Builder actionsEnabled(Boolean var1);

        public Builder alarmActions(Collection<String> var1);

        public Builder alarmActions(String ... var1);

        public Builder alarmDescription(String var1);

        public Builder alarmName(String var1);

        public Builder alarmRule(String var1);

        public Builder insufficientDataActions(Collection<String> var1);

        public Builder insufficientDataActions(String ... var1);

        public Builder okActions(Collection<String> var1);

        public Builder okActions(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

