/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatch.model.AnomalyDetector;
import software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorsCopier;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAnomalyDetectorsResponse
extends CloudWatchResponse
implements ToCopyableBuilder<Builder, DescribeAnomalyDetectorsResponse> {
    private static final SdkField<List<AnomalyDetector>> ANOMALY_DETECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AnomalyDetectors").getter(DescribeAnomalyDetectorsResponse.getter(DescribeAnomalyDetectorsResponse::anomalyDetectors)).setter(DescribeAnomalyDetectorsResponse.setter(Builder::anomalyDetectors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnomalyDetector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeAnomalyDetectorsResponse.getter(DescribeAnomalyDetectorsResponse::nextToken)).setter(DescribeAnomalyDetectorsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_DETECTORS_FIELD, NEXT_TOKEN_FIELD));
    private final List<AnomalyDetector> anomalyDetectors;
    private final String nextToken;

    private DescribeAnomalyDetectorsResponse(BuilderImpl builder) {
        super(builder);
        this.anomalyDetectors = builder.anomalyDetectors;
        this.nextToken = builder.nextToken;
    }

    public boolean hasAnomalyDetectors() {
        return this.anomalyDetectors != null && !(this.anomalyDetectors instanceof SdkAutoConstructList);
    }

    public List<AnomalyDetector> anomalyDetectors() {
        return this.anomalyDetectors;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyDetectors());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAnomalyDetectorsResponse)) {
            return false;
        }
        DescribeAnomalyDetectorsResponse other = (DescribeAnomalyDetectorsResponse)((Object)obj);
        return Objects.equals(this.anomalyDetectors(), other.anomalyDetectors()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeAnomalyDetectorsResponse").add("AnomalyDetectors", this.anomalyDetectors()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AnomalyDetectors": {
                return Optional.ofNullable(clazz.cast(this.anomalyDetectors()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAnomalyDetectorsResponse, T> g) {
        return obj -> g.apply((DescribeAnomalyDetectorsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchResponse.BuilderImpl
    implements Builder {
        private List<AnomalyDetector> anomalyDetectors = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAnomalyDetectorsResponse model) {
            super(model);
            this.anomalyDetectors(model.anomalyDetectors);
            this.nextToken(model.nextToken);
        }

        public final Collection<AnomalyDetector.Builder> getAnomalyDetectors() {
            return this.anomalyDetectors != null ? (Collection)this.anomalyDetectors.stream().map(AnomalyDetector::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder anomalyDetectors(Collection<AnomalyDetector> anomalyDetectors) {
            this.anomalyDetectors = AnomalyDetectorsCopier.copy(anomalyDetectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder anomalyDetectors(AnomalyDetector ... anomalyDetectors) {
            this.anomalyDetectors(Arrays.asList(anomalyDetectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder anomalyDetectors(Consumer<AnomalyDetector.Builder> ... anomalyDetectors) {
            this.anomalyDetectors(Stream.of(anomalyDetectors).map(c -> (AnomalyDetector)((AnomalyDetector.Builder)AnomalyDetector.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAnomalyDetectors(Collection<AnomalyDetector.BuilderImpl> anomalyDetectors) {
            this.anomalyDetectors = AnomalyDetectorsCopier.copyFromBuilder(anomalyDetectors);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeAnomalyDetectorsResponse build() {
            return new DescribeAnomalyDetectorsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAnomalyDetectorsResponse> {
        public Builder anomalyDetectors(Collection<AnomalyDetector> var1);

        public Builder anomalyDetectors(AnomalyDetector ... var1);

        public Builder anomalyDetectors(Consumer<AnomalyDetector.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

