/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatch.model.AlarmNamesCopier;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchRequest;
import software.amazon.awssdk.services.cloudwatch.model.StateValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAlarmsRequest
extends CloudWatchRequest
implements ToCopyableBuilder<Builder, DescribeAlarmsRequest> {
    private static final SdkField<List<String>> ALARM_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeAlarmsRequest.getter(DescribeAlarmsRequest::alarmNames)).setter(DescribeAlarmsRequest.setter(Builder::alarmNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ALARM_NAME_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeAlarmsRequest.getter(DescribeAlarmsRequest::alarmNamePrefix)).setter(DescribeAlarmsRequest.setter(Builder::alarmNamePrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmNamePrefix").build()}).build();
    private static final SdkField<String> STATE_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeAlarmsRequest.getter(DescribeAlarmsRequest::stateValueAsString)).setter(DescribeAlarmsRequest.setter(Builder::stateValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateValue").build()}).build();
    private static final SdkField<String> ACTION_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeAlarmsRequest.getter(DescribeAlarmsRequest::actionPrefix)).setter(DescribeAlarmsRequest.setter(Builder::actionPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionPrefix").build()}).build();
    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DescribeAlarmsRequest.getter(DescribeAlarmsRequest::maxRecords)).setter(DescribeAlarmsRequest.setter(Builder::maxRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeAlarmsRequest.getter(DescribeAlarmsRequest::nextToken)).setter(DescribeAlarmsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARM_NAMES_FIELD, ALARM_NAME_PREFIX_FIELD, STATE_VALUE_FIELD, ACTION_PREFIX_FIELD, MAX_RECORDS_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> alarmNames;
    private final String alarmNamePrefix;
    private final String stateValue;
    private final String actionPrefix;
    private final Integer maxRecords;
    private final String nextToken;

    private DescribeAlarmsRequest(BuilderImpl builder) {
        super(builder);
        this.alarmNames = builder.alarmNames;
        this.alarmNamePrefix = builder.alarmNamePrefix;
        this.stateValue = builder.stateValue;
        this.actionPrefix = builder.actionPrefix;
        this.maxRecords = builder.maxRecords;
        this.nextToken = builder.nextToken;
    }

    public List<String> alarmNames() {
        return this.alarmNames;
    }

    public String alarmNamePrefix() {
        return this.alarmNamePrefix;
    }

    public StateValue stateValue() {
        return StateValue.fromValue(this.stateValue);
    }

    public String stateValueAsString() {
        return this.stateValue;
    }

    public String actionPrefix() {
        return this.actionPrefix;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmNamePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateValueAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAlarmsRequest)) {
            return false;
        }
        DescribeAlarmsRequest other = (DescribeAlarmsRequest)((Object)obj);
        return Objects.equals(this.alarmNames(), other.alarmNames()) && Objects.equals(this.alarmNamePrefix(), other.alarmNamePrefix()) && Objects.equals(this.stateValueAsString(), other.stateValueAsString()) && Objects.equals(this.actionPrefix(), other.actionPrefix()) && Objects.equals(this.maxRecords(), other.maxRecords()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeAlarmsRequest").add("AlarmNames", this.alarmNames()).add("AlarmNamePrefix", (Object)this.alarmNamePrefix()).add("StateValue", (Object)this.stateValueAsString()).add("ActionPrefix", (Object)this.actionPrefix()).add("MaxRecords", (Object)this.maxRecords()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AlarmNames": {
                return Optional.ofNullable(clazz.cast(this.alarmNames()));
            }
            case "AlarmNamePrefix": {
                return Optional.ofNullable(clazz.cast(this.alarmNamePrefix()));
            }
            case "StateValue": {
                return Optional.ofNullable(clazz.cast(this.stateValueAsString()));
            }
            case "ActionPrefix": {
                return Optional.ofNullable(clazz.cast(this.actionPrefix()));
            }
            case "MaxRecords": {
                return Optional.ofNullable(clazz.cast(this.maxRecords()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAlarmsRequest, T> g) {
        return obj -> g.apply((DescribeAlarmsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchRequest.BuilderImpl
    implements Builder {
        private List<String> alarmNames = DefaultSdkAutoConstructList.getInstance();
        private String alarmNamePrefix;
        private String stateValue;
        private String actionPrefix;
        private Integer maxRecords;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAlarmsRequest model) {
            super(model);
            this.alarmNames(model.alarmNames);
            this.alarmNamePrefix(model.alarmNamePrefix);
            this.stateValue(model.stateValue);
            this.actionPrefix(model.actionPrefix);
            this.maxRecords(model.maxRecords);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getAlarmNames() {
            return this.alarmNames;
        }

        @Override
        public final Builder alarmNames(Collection<String> alarmNames) {
            this.alarmNames = AlarmNamesCopier.copy(alarmNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmNames(String ... alarmNames) {
            this.alarmNames(Arrays.asList(alarmNames));
            return this;
        }

        public final void setAlarmNames(Collection<String> alarmNames) {
            this.alarmNames = AlarmNamesCopier.copy(alarmNames);
        }

        public final String getAlarmNamePrefix() {
            return this.alarmNamePrefix;
        }

        @Override
        public final Builder alarmNamePrefix(String alarmNamePrefix) {
            this.alarmNamePrefix = alarmNamePrefix;
            return this;
        }

        public final void setAlarmNamePrefix(String alarmNamePrefix) {
            this.alarmNamePrefix = alarmNamePrefix;
        }

        public final String getStateValueAsString() {
            return this.stateValue;
        }

        @Override
        public final Builder stateValue(String stateValue) {
            this.stateValue = stateValue;
            return this;
        }

        @Override
        public final Builder stateValue(StateValue stateValue) {
            this.stateValue(stateValue == null ? null : stateValue.toString());
            return this;
        }

        public final void setStateValue(String stateValue) {
            this.stateValue = stateValue;
        }

        public final String getActionPrefix() {
            return this.actionPrefix;
        }

        @Override
        public final Builder actionPrefix(String actionPrefix) {
            this.actionPrefix = actionPrefix;
            return this;
        }

        public final void setActionPrefix(String actionPrefix) {
            this.actionPrefix = actionPrefix;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAlarmsRequest build() {
            return new DescribeAlarmsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAlarmsRequest> {
        public Builder alarmNames(Collection<String> var1);

        public Builder alarmNames(String ... var1);

        public Builder alarmNamePrefix(String var1);

        public Builder stateValue(String var1);

        public Builder stateValue(StateValue var1);

        public Builder actionPrefix(String var1);

        public Builder maxRecords(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

