/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.transform;

import java.time.Instant;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmHistoryRequest;

public class DescribeAlarmHistoryRequestMarshaller
implements Marshaller<Request<DescribeAlarmHistoryRequest>, DescribeAlarmHistoryRequest> {
    public Request<DescribeAlarmHistoryRequest> marshall(DescribeAlarmHistoryRequest describeAlarmHistoryRequest) {
        if (describeAlarmHistoryRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeAlarmHistoryRequest, "CloudWatchClient");
        request.addParameter("Action", "DescribeAlarmHistory");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeAlarmHistoryRequest.alarmName() != null) {
            request.addParameter("AlarmName", StringConversion.fromString((String)describeAlarmHistoryRequest.alarmName()));
        }
        if (describeAlarmHistoryRequest.historyItemTypeAsString() != null) {
            request.addParameter("HistoryItemType", StringConversion.fromString((String)describeAlarmHistoryRequest.historyItemTypeAsString()));
        }
        if (describeAlarmHistoryRequest.startDate() != null) {
            request.addParameter("StartDate", StringConversion.fromInstant((Instant)describeAlarmHistoryRequest.startDate()));
        }
        if (describeAlarmHistoryRequest.endDate() != null) {
            request.addParameter("EndDate", StringConversion.fromInstant((Instant)describeAlarmHistoryRequest.endDate()));
        }
        if (describeAlarmHistoryRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger((Integer)describeAlarmHistoryRequest.maxRecords()));
        }
        if (describeAlarmHistoryRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeAlarmHistoryRequest.nextToken()));
        }
        return request;
    }
}

