/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.cloudwatch.model.Metric;
import software.amazon.awssdk.services.cloudwatch.model.StandardUnit;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricStat
implements ToCopyableBuilder<Builder, MetricStat> {
    private final Metric metric;
    private final Integer period;
    private final String stat;
    private final String unit;

    private MetricStat(BuilderImpl builder) {
        this.metric = builder.metric;
        this.period = builder.period;
        this.stat = builder.stat;
        this.unit = builder.unit;
    }

    public Metric metric() {
        return this.metric;
    }

    public Integer period() {
        return this.period;
    }

    public String stat() {
        return this.stat;
    }

    public StandardUnit unit() {
        return StandardUnit.fromValue(this.unit);
    }

    public String unitAsString() {
        return this.unit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metric());
        hashCode = 31 * hashCode + Objects.hashCode(this.period());
        hashCode = 31 * hashCode + Objects.hashCode(this.stat());
        hashCode = 31 * hashCode + Objects.hashCode(this.unitAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricStat)) {
            return false;
        }
        MetricStat other = (MetricStat)obj;
        return Objects.equals(this.metric(), other.metric()) && Objects.equals(this.period(), other.period()) && Objects.equals(this.stat(), other.stat()) && Objects.equals(this.unitAsString(), other.unitAsString());
    }

    public String toString() {
        return ToString.builder((String)"MetricStat").add("Metric", (Object)this.metric()).add("Period", (Object)this.period()).add("Stat", (Object)this.stat()).add("Unit", (Object)this.unitAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Metric": {
                return Optional.ofNullable(clazz.cast(this.metric()));
            }
            case "Period": {
                return Optional.ofNullable(clazz.cast(this.period()));
            }
            case "Stat": {
                return Optional.ofNullable(clazz.cast(this.stat()));
            }
            case "Unit": {
                return Optional.ofNullable(clazz.cast(this.unitAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Metric metric;
        private Integer period;
        private String stat;
        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricStat model) {
            this.metric(model.metric);
            this.period(model.period);
            this.stat(model.stat);
            this.unit(model.unit);
        }

        public final Metric.Builder getMetric() {
            return this.metric != null ? this.metric.toBuilder() : null;
        }

        @Override
        public final Builder metric(Metric metric) {
            this.metric = metric;
            return this;
        }

        public final void setMetric(Metric.BuilderImpl metric) {
            this.metric = metric != null ? metric.build() : null;
        }

        public final Integer getPeriod() {
            return this.period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        public final String getStat() {
            return this.stat;
        }

        @Override
        public final Builder stat(String stat) {
            this.stat = stat;
            return this;
        }

        public final void setStat(String stat) {
            this.stat = stat;
        }

        public final String getUnit() {
            return this.unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(StandardUnit unit) {
            this.unit(unit.toString());
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        public MetricStat build() {
            return new MetricStat(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MetricStat> {
        public Builder metric(Metric var1);

        default public Builder metric(Consumer<Metric.Builder> metric) {
            return this.metric((Metric)((Metric.Builder)Metric.builder().applyMutation(metric)).build());
        }

        public Builder period(Integer var1);

        public Builder stat(String var1);

        public Builder unit(String var1);

        public Builder unit(StandardUnit var1);
    }
}

