/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StatisticSet
implements ToCopyableBuilder<Builder, StatisticSet> {
    private final Double sampleCount;
    private final Double sum;
    private final Double minimum;
    private final Double maximum;

    private StatisticSet(BuilderImpl builder) {
        this.sampleCount = builder.sampleCount;
        this.sum = builder.sum;
        this.minimum = builder.minimum;
        this.maximum = builder.maximum;
    }

    public Double sampleCount() {
        return this.sampleCount;
    }

    public Double sum() {
        return this.sum;
    }

    public Double minimum() {
        return this.minimum;
    }

    public Double maximum() {
        return this.maximum;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.sum());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimum());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximum());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatisticSet)) {
            return false;
        }
        StatisticSet other = (StatisticSet)obj;
        return Objects.equals(this.sampleCount(), other.sampleCount()) && Objects.equals(this.sum(), other.sum()) && Objects.equals(this.minimum(), other.minimum()) && Objects.equals(this.maximum(), other.maximum());
    }

    public String toString() {
        return ToString.builder((String)"StatisticSet").add("SampleCount", (Object)this.sampleCount()).add("Sum", (Object)this.sum()).add("Minimum", (Object)this.minimum()).add("Maximum", (Object)this.maximum()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SampleCount": {
                return Optional.ofNullable(clazz.cast(this.sampleCount()));
            }
            case "Sum": {
                return Optional.ofNullable(clazz.cast(this.sum()));
            }
            case "Minimum": {
                return Optional.ofNullable(clazz.cast(this.minimum()));
            }
            case "Maximum": {
                return Optional.ofNullable(clazz.cast(this.maximum()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Double sampleCount;
        private Double sum;
        private Double minimum;
        private Double maximum;

        private BuilderImpl() {
        }

        private BuilderImpl(StatisticSet model) {
            this.sampleCount(model.sampleCount);
            this.sum(model.sum);
            this.minimum(model.minimum);
            this.maximum(model.maximum);
        }

        public final Double getSampleCount() {
            return this.sampleCount;
        }

        @Override
        public final Builder sampleCount(Double sampleCount) {
            this.sampleCount = sampleCount;
            return this;
        }

        public final void setSampleCount(Double sampleCount) {
            this.sampleCount = sampleCount;
        }

        public final Double getSum() {
            return this.sum;
        }

        @Override
        public final Builder sum(Double sum) {
            this.sum = sum;
            return this;
        }

        public final void setSum(Double sum) {
            this.sum = sum;
        }

        public final Double getMinimum() {
            return this.minimum;
        }

        @Override
        public final Builder minimum(Double minimum) {
            this.minimum = minimum;
            return this;
        }

        public final void setMinimum(Double minimum) {
            this.minimum = minimum;
        }

        public final Double getMaximum() {
            return this.maximum;
        }

        @Override
        public final Builder maximum(Double maximum) {
            this.maximum = maximum;
            return this;
        }

        public final void setMaximum(Double maximum) {
            this.maximum = maximum;
        }

        public StatisticSet build() {
            return new StatisticSet(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StatisticSet> {
        public Builder sampleCount(Double var1);

        public Builder sum(Double var1);

        public Builder minimum(Double var1);

        public Builder maximum(Double var1);
    }
}

