/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.DimensionsCopier;
import software.amazon.awssdk.services.cloudwatch.model.StandardUnit;
import software.amazon.awssdk.services.cloudwatch.model.StatisticSet;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MetricDatum
implements ToCopyableBuilder<Builder, MetricDatum> {
    private final String metricName;
    private final List<Dimension> dimensions;
    private final Instant timestamp;
    private final Double value;
    private final StatisticSet statisticValues;
    private final String unit;
    private final Integer storageResolution;

    private MetricDatum(BuilderImpl builder) {
        this.metricName = builder.metricName;
        this.dimensions = builder.dimensions;
        this.timestamp = builder.timestamp;
        this.value = builder.value;
        this.statisticValues = builder.statisticValues;
        this.unit = builder.unit;
        this.storageResolution = builder.storageResolution;
    }

    public String metricName() {
        return this.metricName;
    }

    public List<Dimension> dimensions() {
        return this.dimensions;
    }

    public Instant timestamp() {
        return this.timestamp;
    }

    public Double value() {
        return this.value;
    }

    public StatisticSet statisticValues() {
        return this.statisticValues;
    }

    public StandardUnit unit() {
        return StandardUnit.fromValue(this.unit);
    }

    public String unitString() {
        return this.unit;
    }

    public Integer storageResolution() {
        return this.storageResolution;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dimensions());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.statisticValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.unitString());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageResolution());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricDatum)) {
            return false;
        }
        MetricDatum other = (MetricDatum)obj;
        return Objects.equals(this.metricName(), other.metricName()) && Objects.equals(this.dimensions(), other.dimensions()) && Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.statisticValues(), other.statisticValues()) && Objects.equals(this.unitString(), other.unitString()) && Objects.equals(this.storageResolution(), other.storageResolution());
    }

    public String toString() {
        return ToString.builder((String)"MetricDatum").add("MetricName", (Object)this.metricName()).add("Dimensions", this.dimensions()).add("Timestamp", (Object)this.timestamp()).add("Value", (Object)this.value()).add("StatisticValues", (Object)this.statisticValues()).add("Unit", (Object)this.unitString()).add("StorageResolution", (Object)this.storageResolution()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetricName": {
                return Optional.of(clazz.cast(this.metricName()));
            }
            case "Dimensions": {
                return Optional.of(clazz.cast(this.dimensions()));
            }
            case "Timestamp": {
                return Optional.of(clazz.cast(this.timestamp()));
            }
            case "Value": {
                return Optional.of(clazz.cast(this.value()));
            }
            case "StatisticValues": {
                return Optional.of(clazz.cast(this.statisticValues()));
            }
            case "Unit": {
                return Optional.of(clazz.cast(this.unitString()));
            }
            case "StorageResolution": {
                return Optional.of(clazz.cast(this.storageResolution()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String metricName;
        private List<Dimension> dimensions;
        private Instant timestamp;
        private Double value;
        private StatisticSet statisticValues;
        private String unit;
        private Integer storageResolution;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricDatum model) {
            this.metricName(model.metricName);
            this.dimensions(model.dimensions);
            this.timestamp(model.timestamp);
            this.value(model.value);
            this.statisticValues(model.statisticValues);
            this.unit(model.unit);
            this.storageResolution(model.storageResolution);
        }

        public final String getMetricName() {
            return this.metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final Collection<Dimension.Builder> getDimensions() {
            return this.dimensions != null ? (Collection)this.dimensions.stream().map(Dimension::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dimensions(Collection<Dimension> dimensions) {
            this.dimensions = DimensionsCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Dimension ... dimensions) {
            this.dimensions(Arrays.asList(dimensions));
            return this;
        }

        public final void setDimensions(Collection<Dimension.BuilderImpl> dimensions) {
            this.dimensions = DimensionsCopier.copyFromBuilder(dimensions);
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public final Double getValue() {
            return this.value;
        }

        @Override
        public final Builder value(Double value) {
            this.value = value;
            return this;
        }

        public final void setValue(Double value) {
            this.value = value;
        }

        public final StatisticSet.Builder getStatisticValues() {
            return this.statisticValues != null ? this.statisticValues.toBuilder() : null;
        }

        @Override
        public final Builder statisticValues(StatisticSet statisticValues) {
            this.statisticValues = statisticValues;
            return this;
        }

        public final void setStatisticValues(StatisticSet.BuilderImpl statisticValues) {
            this.statisticValues = statisticValues != null ? statisticValues.build() : null;
        }

        public final String getUnit() {
            return this.unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(StandardUnit unit) {
            this.unit(unit.toString());
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        public final Integer getStorageResolution() {
            return this.storageResolution;
        }

        @Override
        public final Builder storageResolution(Integer storageResolution) {
            this.storageResolution = storageResolution;
            return this;
        }

        public final void setStorageResolution(Integer storageResolution) {
            this.storageResolution = storageResolution;
        }

        public MetricDatum build() {
            return new MetricDatum(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MetricDatum> {
        public Builder metricName(String var1);

        public Builder dimensions(Collection<Dimension> var1);

        public Builder dimensions(Dimension ... var1);

        public Builder timestamp(Instant var1);

        public Builder value(Double var1);

        public Builder statisticValues(StatisticSet var1);

        default public Builder statisticValues(Consumer<StatisticSet.Builder> statisticValues) {
            return this.statisticValues((StatisticSet)((StatisticSet.Builder)StatisticSet.builder().apply(statisticValues)).build());
        }

        public Builder unit(String var1);

        public Builder unit(StandardUnit var1);

        public Builder storageResolution(Integer var1);
    }
}

