/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.cloudwatch.model.ComparisonOperator;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.DimensionsCopier;
import software.amazon.awssdk.services.cloudwatch.model.ResourceListCopier;
import software.amazon.awssdk.services.cloudwatch.model.StandardUnit;
import software.amazon.awssdk.services.cloudwatch.model.StateValue;
import software.amazon.awssdk.services.cloudwatch.model.Statistic;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MetricAlarm
implements ToCopyableBuilder<Builder, MetricAlarm> {
    private final String alarmName;
    private final String alarmArn;
    private final String alarmDescription;
    private final Instant alarmConfigurationUpdatedTimestamp;
    private final Boolean actionsEnabled;
    private final List<String> okActions;
    private final List<String> alarmActions;
    private final List<String> insufficientDataActions;
    private final String stateValue;
    private final String stateReason;
    private final String stateReasonData;
    private final Instant stateUpdatedTimestamp;
    private final String metricName;
    private final String namespace;
    private final String statistic;
    private final String extendedStatistic;
    private final List<Dimension> dimensions;
    private final Integer period;
    private final String unit;
    private final Integer evaluationPeriods;
    private final Double threshold;
    private final String comparisonOperator;
    private final String treatMissingData;
    private final String evaluateLowSampleCountPercentile;

    private MetricAlarm(BuilderImpl builder) {
        this.alarmName = builder.alarmName;
        this.alarmArn = builder.alarmArn;
        this.alarmDescription = builder.alarmDescription;
        this.alarmConfigurationUpdatedTimestamp = builder.alarmConfigurationUpdatedTimestamp;
        this.actionsEnabled = builder.actionsEnabled;
        this.okActions = builder.okActions;
        this.alarmActions = builder.alarmActions;
        this.insufficientDataActions = builder.insufficientDataActions;
        this.stateValue = builder.stateValue;
        this.stateReason = builder.stateReason;
        this.stateReasonData = builder.stateReasonData;
        this.stateUpdatedTimestamp = builder.stateUpdatedTimestamp;
        this.metricName = builder.metricName;
        this.namespace = builder.namespace;
        this.statistic = builder.statistic;
        this.extendedStatistic = builder.extendedStatistic;
        this.dimensions = builder.dimensions;
        this.period = builder.period;
        this.unit = builder.unit;
        this.evaluationPeriods = builder.evaluationPeriods;
        this.threshold = builder.threshold;
        this.comparisonOperator = builder.comparisonOperator;
        this.treatMissingData = builder.treatMissingData;
        this.evaluateLowSampleCountPercentile = builder.evaluateLowSampleCountPercentile;
    }

    public String alarmName() {
        return this.alarmName;
    }

    public String alarmArn() {
        return this.alarmArn;
    }

    public String alarmDescription() {
        return this.alarmDescription;
    }

    public Instant alarmConfigurationUpdatedTimestamp() {
        return this.alarmConfigurationUpdatedTimestamp;
    }

    public Boolean actionsEnabled() {
        return this.actionsEnabled;
    }

    public List<String> okActions() {
        return this.okActions;
    }

    public List<String> alarmActions() {
        return this.alarmActions;
    }

    public List<String> insufficientDataActions() {
        return this.insufficientDataActions;
    }

    public StateValue stateValue() {
        return StateValue.fromValue(this.stateValue);
    }

    public String stateValueString() {
        return this.stateValue;
    }

    public String stateReason() {
        return this.stateReason;
    }

    public String stateReasonData() {
        return this.stateReasonData;
    }

    public Instant stateUpdatedTimestamp() {
        return this.stateUpdatedTimestamp;
    }

    public String metricName() {
        return this.metricName;
    }

    public String namespace() {
        return this.namespace;
    }

    public Statistic statistic() {
        return Statistic.fromValue(this.statistic);
    }

    public String statisticString() {
        return this.statistic;
    }

    public String extendedStatistic() {
        return this.extendedStatistic;
    }

    public List<Dimension> dimensions() {
        return this.dimensions;
    }

    public Integer period() {
        return this.period;
    }

    public StandardUnit unit() {
        return StandardUnit.fromValue(this.unit);
    }

    public String unitString() {
        return this.unit;
    }

    public Integer evaluationPeriods() {
        return this.evaluationPeriods;
    }

    public Double threshold() {
        return this.threshold;
    }

    public ComparisonOperator comparisonOperator() {
        return ComparisonOperator.fromValue(this.comparisonOperator);
    }

    public String comparisonOperatorString() {
        return this.comparisonOperator;
    }

    public String treatMissingData() {
        return this.treatMissingData;
    }

    public String evaluateLowSampleCountPercentile() {
        return this.evaluateLowSampleCountPercentile;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmName());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmConfigurationUpdatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.okActions());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmActions());
        hashCode = 31 * hashCode + Objects.hashCode(this.insufficientDataActions());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateValueString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateReasonData());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateUpdatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.statisticString());
        hashCode = 31 * hashCode + Objects.hashCode(this.extendedStatistic());
        hashCode = 31 * hashCode + Objects.hashCode(this.dimensions());
        hashCode = 31 * hashCode + Objects.hashCode(this.period());
        hashCode = 31 * hashCode + Objects.hashCode(this.unitString());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationPeriods());
        hashCode = 31 * hashCode + Objects.hashCode(this.threshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.comparisonOperatorString());
        hashCode = 31 * hashCode + Objects.hashCode(this.treatMissingData());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluateLowSampleCountPercentile());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricAlarm)) {
            return false;
        }
        MetricAlarm other = (MetricAlarm)obj;
        return Objects.equals(this.alarmName(), other.alarmName()) && Objects.equals(this.alarmArn(), other.alarmArn()) && Objects.equals(this.alarmDescription(), other.alarmDescription()) && Objects.equals(this.alarmConfigurationUpdatedTimestamp(), other.alarmConfigurationUpdatedTimestamp()) && Objects.equals(this.actionsEnabled(), other.actionsEnabled()) && Objects.equals(this.okActions(), other.okActions()) && Objects.equals(this.alarmActions(), other.alarmActions()) && Objects.equals(this.insufficientDataActions(), other.insufficientDataActions()) && Objects.equals(this.stateValueString(), other.stateValueString()) && Objects.equals(this.stateReason(), other.stateReason()) && Objects.equals(this.stateReasonData(), other.stateReasonData()) && Objects.equals(this.stateUpdatedTimestamp(), other.stateUpdatedTimestamp()) && Objects.equals(this.metricName(), other.metricName()) && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.statisticString(), other.statisticString()) && Objects.equals(this.extendedStatistic(), other.extendedStatistic()) && Objects.equals(this.dimensions(), other.dimensions()) && Objects.equals(this.period(), other.period()) && Objects.equals(this.unitString(), other.unitString()) && Objects.equals(this.evaluationPeriods(), other.evaluationPeriods()) && Objects.equals(this.threshold(), other.threshold()) && Objects.equals(this.comparisonOperatorString(), other.comparisonOperatorString()) && Objects.equals(this.treatMissingData(), other.treatMissingData()) && Objects.equals(this.evaluateLowSampleCountPercentile(), other.evaluateLowSampleCountPercentile());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.alarmName() != null) {
            sb.append("AlarmName: ").append(this.alarmName()).append(",");
        }
        if (this.alarmArn() != null) {
            sb.append("AlarmArn: ").append(this.alarmArn()).append(",");
        }
        if (this.alarmDescription() != null) {
            sb.append("AlarmDescription: ").append(this.alarmDescription()).append(",");
        }
        if (this.alarmConfigurationUpdatedTimestamp() != null) {
            sb.append("AlarmConfigurationUpdatedTimestamp: ").append(this.alarmConfigurationUpdatedTimestamp()).append(",");
        }
        if (this.actionsEnabled() != null) {
            sb.append("ActionsEnabled: ").append(this.actionsEnabled()).append(",");
        }
        if (this.okActions() != null) {
            sb.append("OKActions: ").append(this.okActions()).append(",");
        }
        if (this.alarmActions() != null) {
            sb.append("AlarmActions: ").append(this.alarmActions()).append(",");
        }
        if (this.insufficientDataActions() != null) {
            sb.append("InsufficientDataActions: ").append(this.insufficientDataActions()).append(",");
        }
        if (this.stateValueString() != null) {
            sb.append("StateValue: ").append(this.stateValueString()).append(",");
        }
        if (this.stateReason() != null) {
            sb.append("StateReason: ").append(this.stateReason()).append(",");
        }
        if (this.stateReasonData() != null) {
            sb.append("StateReasonData: ").append(this.stateReasonData()).append(",");
        }
        if (this.stateUpdatedTimestamp() != null) {
            sb.append("StateUpdatedTimestamp: ").append(this.stateUpdatedTimestamp()).append(",");
        }
        if (this.metricName() != null) {
            sb.append("MetricName: ").append(this.metricName()).append(",");
        }
        if (this.namespace() != null) {
            sb.append("Namespace: ").append(this.namespace()).append(",");
        }
        if (this.statisticString() != null) {
            sb.append("Statistic: ").append(this.statisticString()).append(",");
        }
        if (this.extendedStatistic() != null) {
            sb.append("ExtendedStatistic: ").append(this.extendedStatistic()).append(",");
        }
        if (this.dimensions() != null) {
            sb.append("Dimensions: ").append(this.dimensions()).append(",");
        }
        if (this.period() != null) {
            sb.append("Period: ").append(this.period()).append(",");
        }
        if (this.unitString() != null) {
            sb.append("Unit: ").append(this.unitString()).append(",");
        }
        if (this.evaluationPeriods() != null) {
            sb.append("EvaluationPeriods: ").append(this.evaluationPeriods()).append(",");
        }
        if (this.threshold() != null) {
            sb.append("Threshold: ").append(this.threshold()).append(",");
        }
        if (this.comparisonOperatorString() != null) {
            sb.append("ComparisonOperator: ").append(this.comparisonOperatorString()).append(",");
        }
        if (this.treatMissingData() != null) {
            sb.append("TreatMissingData: ").append(this.treatMissingData()).append(",");
        }
        if (this.evaluateLowSampleCountPercentile() != null) {
            sb.append("EvaluateLowSampleCountPercentile: ").append(this.evaluateLowSampleCountPercentile()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AlarmName": {
                return Optional.of(clazz.cast(this.alarmName()));
            }
            case "AlarmArn": {
                return Optional.of(clazz.cast(this.alarmArn()));
            }
            case "AlarmDescription": {
                return Optional.of(clazz.cast(this.alarmDescription()));
            }
            case "AlarmConfigurationUpdatedTimestamp": {
                return Optional.of(clazz.cast(this.alarmConfigurationUpdatedTimestamp()));
            }
            case "ActionsEnabled": {
                return Optional.of(clazz.cast(this.actionsEnabled()));
            }
            case "OKActions": {
                return Optional.of(clazz.cast(this.okActions()));
            }
            case "AlarmActions": {
                return Optional.of(clazz.cast(this.alarmActions()));
            }
            case "InsufficientDataActions": {
                return Optional.of(clazz.cast(this.insufficientDataActions()));
            }
            case "StateValue": {
                return Optional.of(clazz.cast(this.stateValueString()));
            }
            case "StateReason": {
                return Optional.of(clazz.cast(this.stateReason()));
            }
            case "StateReasonData": {
                return Optional.of(clazz.cast(this.stateReasonData()));
            }
            case "StateUpdatedTimestamp": {
                return Optional.of(clazz.cast(this.stateUpdatedTimestamp()));
            }
            case "MetricName": {
                return Optional.of(clazz.cast(this.metricName()));
            }
            case "Namespace": {
                return Optional.of(clazz.cast(this.namespace()));
            }
            case "Statistic": {
                return Optional.of(clazz.cast(this.statisticString()));
            }
            case "ExtendedStatistic": {
                return Optional.of(clazz.cast(this.extendedStatistic()));
            }
            case "Dimensions": {
                return Optional.of(clazz.cast(this.dimensions()));
            }
            case "Period": {
                return Optional.of(clazz.cast(this.period()));
            }
            case "Unit": {
                return Optional.of(clazz.cast(this.unitString()));
            }
            case "EvaluationPeriods": {
                return Optional.of(clazz.cast(this.evaluationPeriods()));
            }
            case "Threshold": {
                return Optional.of(clazz.cast(this.threshold()));
            }
            case "ComparisonOperator": {
                return Optional.of(clazz.cast(this.comparisonOperatorString()));
            }
            case "TreatMissingData": {
                return Optional.of(clazz.cast(this.treatMissingData()));
            }
            case "EvaluateLowSampleCountPercentile": {
                return Optional.of(clazz.cast(this.evaluateLowSampleCountPercentile()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String alarmName;
        private String alarmArn;
        private String alarmDescription;
        private Instant alarmConfigurationUpdatedTimestamp;
        private Boolean actionsEnabled;
        private List<String> okActions;
        private List<String> alarmActions;
        private List<String> insufficientDataActions;
        private String stateValue;
        private String stateReason;
        private String stateReasonData;
        private Instant stateUpdatedTimestamp;
        private String metricName;
        private String namespace;
        private String statistic;
        private String extendedStatistic;
        private List<Dimension> dimensions;
        private Integer period;
        private String unit;
        private Integer evaluationPeriods;
        private Double threshold;
        private String comparisonOperator;
        private String treatMissingData;
        private String evaluateLowSampleCountPercentile;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricAlarm model) {
            this.alarmName(model.alarmName);
            this.alarmArn(model.alarmArn);
            this.alarmDescription(model.alarmDescription);
            this.alarmConfigurationUpdatedTimestamp(model.alarmConfigurationUpdatedTimestamp);
            this.actionsEnabled(model.actionsEnabled);
            this.okActions(model.okActions);
            this.alarmActions(model.alarmActions);
            this.insufficientDataActions(model.insufficientDataActions);
            this.stateValue(model.stateValue);
            this.stateReason(model.stateReason);
            this.stateReasonData(model.stateReasonData);
            this.stateUpdatedTimestamp(model.stateUpdatedTimestamp);
            this.metricName(model.metricName);
            this.namespace(model.namespace);
            this.statistic(model.statistic);
            this.extendedStatistic(model.extendedStatistic);
            this.dimensions(model.dimensions);
            this.period(model.period);
            this.unit(model.unit);
            this.evaluationPeriods(model.evaluationPeriods);
            this.threshold(model.threshold);
            this.comparisonOperator(model.comparisonOperator);
            this.treatMissingData(model.treatMissingData);
            this.evaluateLowSampleCountPercentile(model.evaluateLowSampleCountPercentile);
        }

        public final String getAlarmName() {
            return this.alarmName;
        }

        @Override
        public final Builder alarmName(String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        public final void setAlarmName(String alarmName) {
            this.alarmName = alarmName;
        }

        public final String getAlarmArn() {
            return this.alarmArn;
        }

        @Override
        public final Builder alarmArn(String alarmArn) {
            this.alarmArn = alarmArn;
            return this;
        }

        public final void setAlarmArn(String alarmArn) {
            this.alarmArn = alarmArn;
        }

        public final String getAlarmDescription() {
            return this.alarmDescription;
        }

        @Override
        public final Builder alarmDescription(String alarmDescription) {
            this.alarmDescription = alarmDescription;
            return this;
        }

        public final void setAlarmDescription(String alarmDescription) {
            this.alarmDescription = alarmDescription;
        }

        public final Instant getAlarmConfigurationUpdatedTimestamp() {
            return this.alarmConfigurationUpdatedTimestamp;
        }

        @Override
        public final Builder alarmConfigurationUpdatedTimestamp(Instant alarmConfigurationUpdatedTimestamp) {
            this.alarmConfigurationUpdatedTimestamp = alarmConfigurationUpdatedTimestamp;
            return this;
        }

        public final void setAlarmConfigurationUpdatedTimestamp(Instant alarmConfigurationUpdatedTimestamp) {
            this.alarmConfigurationUpdatedTimestamp = alarmConfigurationUpdatedTimestamp;
        }

        public final Boolean getActionsEnabled() {
            return this.actionsEnabled;
        }

        @Override
        public final Builder actionsEnabled(Boolean actionsEnabled) {
            this.actionsEnabled = actionsEnabled;
            return this;
        }

        public final void setActionsEnabled(Boolean actionsEnabled) {
            this.actionsEnabled = actionsEnabled;
        }

        public final Collection<String> getOKActions() {
            return this.okActions;
        }

        @Override
        public final Builder okActions(Collection<String> okActions) {
            this.okActions = ResourceListCopier.copy(okActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder okActions(String ... okActions) {
            this.okActions(Arrays.asList(okActions));
            return this;
        }

        public final void setOKActions(Collection<String> okActions) {
            this.okActions = ResourceListCopier.copy(okActions);
        }

        public final Collection<String> getAlarmActions() {
            return this.alarmActions;
        }

        @Override
        public final Builder alarmActions(Collection<String> alarmActions) {
            this.alarmActions = ResourceListCopier.copy(alarmActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmActions(String ... alarmActions) {
            this.alarmActions(Arrays.asList(alarmActions));
            return this;
        }

        public final void setAlarmActions(Collection<String> alarmActions) {
            this.alarmActions = ResourceListCopier.copy(alarmActions);
        }

        public final Collection<String> getInsufficientDataActions() {
            return this.insufficientDataActions;
        }

        @Override
        public final Builder insufficientDataActions(Collection<String> insufficientDataActions) {
            this.insufficientDataActions = ResourceListCopier.copy(insufficientDataActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insufficientDataActions(String ... insufficientDataActions) {
            this.insufficientDataActions(Arrays.asList(insufficientDataActions));
            return this;
        }

        public final void setInsufficientDataActions(Collection<String> insufficientDataActions) {
            this.insufficientDataActions = ResourceListCopier.copy(insufficientDataActions);
        }

        public final String getStateValue() {
            return this.stateValue;
        }

        @Override
        public final Builder stateValue(String stateValue) {
            this.stateValue = stateValue;
            return this;
        }

        @Override
        public final Builder stateValue(StateValue stateValue) {
            this.stateValue(stateValue.toString());
            return this;
        }

        public final void setStateValue(String stateValue) {
            this.stateValue = stateValue;
        }

        public final String getStateReason() {
            return this.stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        public final String getStateReasonData() {
            return this.stateReasonData;
        }

        @Override
        public final Builder stateReasonData(String stateReasonData) {
            this.stateReasonData = stateReasonData;
            return this;
        }

        public final void setStateReasonData(String stateReasonData) {
            this.stateReasonData = stateReasonData;
        }

        public final Instant getStateUpdatedTimestamp() {
            return this.stateUpdatedTimestamp;
        }

        @Override
        public final Builder stateUpdatedTimestamp(Instant stateUpdatedTimestamp) {
            this.stateUpdatedTimestamp = stateUpdatedTimestamp;
            return this;
        }

        public final void setStateUpdatedTimestamp(Instant stateUpdatedTimestamp) {
            this.stateUpdatedTimestamp = stateUpdatedTimestamp;
        }

        public final String getMetricName() {
            return this.metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final String getStatistic() {
            return this.statistic;
        }

        @Override
        public final Builder statistic(String statistic) {
            this.statistic = statistic;
            return this;
        }

        @Override
        public final Builder statistic(Statistic statistic) {
            this.statistic(statistic.toString());
            return this;
        }

        public final void setStatistic(String statistic) {
            this.statistic = statistic;
        }

        public final String getExtendedStatistic() {
            return this.extendedStatistic;
        }

        @Override
        public final Builder extendedStatistic(String extendedStatistic) {
            this.extendedStatistic = extendedStatistic;
            return this;
        }

        public final void setExtendedStatistic(String extendedStatistic) {
            this.extendedStatistic = extendedStatistic;
        }

        public final Collection<Dimension.Builder> getDimensions() {
            return this.dimensions != null ? (Collection)this.dimensions.stream().map(Dimension::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dimensions(Collection<Dimension> dimensions) {
            this.dimensions = DimensionsCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Dimension ... dimensions) {
            this.dimensions(Arrays.asList(dimensions));
            return this;
        }

        public final void setDimensions(Collection<Dimension.BuilderImpl> dimensions) {
            this.dimensions = DimensionsCopier.copyFromBuilder(dimensions);
        }

        public final Integer getPeriod() {
            return this.period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        public final String getUnit() {
            return this.unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(StandardUnit unit) {
            this.unit(unit.toString());
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        public final Integer getEvaluationPeriods() {
            return this.evaluationPeriods;
        }

        @Override
        public final Builder evaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
            return this;
        }

        public final void setEvaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
        }

        public final Double getThreshold() {
            return this.threshold;
        }

        @Override
        public final Builder threshold(Double threshold) {
            this.threshold = threshold;
            return this;
        }

        public final void setThreshold(Double threshold) {
            this.threshold = threshold;
        }

        public final String getComparisonOperator() {
            return this.comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        public final Builder comparisonOperator(ComparisonOperator comparisonOperator) {
            this.comparisonOperator(comparisonOperator.toString());
            return this;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        public final String getTreatMissingData() {
            return this.treatMissingData;
        }

        @Override
        public final Builder treatMissingData(String treatMissingData) {
            this.treatMissingData = treatMissingData;
            return this;
        }

        public final void setTreatMissingData(String treatMissingData) {
            this.treatMissingData = treatMissingData;
        }

        public final String getEvaluateLowSampleCountPercentile() {
            return this.evaluateLowSampleCountPercentile;
        }

        @Override
        public final Builder evaluateLowSampleCountPercentile(String evaluateLowSampleCountPercentile) {
            this.evaluateLowSampleCountPercentile = evaluateLowSampleCountPercentile;
            return this;
        }

        public final void setEvaluateLowSampleCountPercentile(String evaluateLowSampleCountPercentile) {
            this.evaluateLowSampleCountPercentile = evaluateLowSampleCountPercentile;
        }

        public MetricAlarm build() {
            return new MetricAlarm(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MetricAlarm> {
        public Builder alarmName(String var1);

        public Builder alarmArn(String var1);

        public Builder alarmDescription(String var1);

        public Builder alarmConfigurationUpdatedTimestamp(Instant var1);

        public Builder actionsEnabled(Boolean var1);

        public Builder okActions(Collection<String> var1);

        public Builder okActions(String ... var1);

        public Builder alarmActions(Collection<String> var1);

        public Builder alarmActions(String ... var1);

        public Builder insufficientDataActions(Collection<String> var1);

        public Builder insufficientDataActions(String ... var1);

        public Builder stateValue(String var1);

        public Builder stateValue(StateValue var1);

        public Builder stateReason(String var1);

        public Builder stateReasonData(String var1);

        public Builder stateUpdatedTimestamp(Instant var1);

        public Builder metricName(String var1);

        public Builder namespace(String var1);

        public Builder statistic(String var1);

        public Builder statistic(Statistic var1);

        public Builder extendedStatistic(String var1);

        public Builder dimensions(Collection<Dimension> var1);

        public Builder dimensions(Dimension ... var1);

        public Builder period(Integer var1);

        public Builder unit(String var1);

        public Builder unit(StandardUnit var1);

        public Builder evaluationPeriods(Integer var1);

        public Builder threshold(Double var1);

        public Builder comparisonOperator(String var1);

        public Builder comparisonOperator(ComparisonOperator var1);

        public Builder treatMissingData(String var1);

        public Builder evaluateLowSampleCountPercentile(String var1);
    }
}

