/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.cloudwatch.model.SetAlarmStateRequest;

public class SetAlarmStateRequestMarshaller
implements Marshaller<Request<SetAlarmStateRequest>, SetAlarmStateRequest> {
    public Request<SetAlarmStateRequest> marshall(SetAlarmStateRequest setAlarmStateRequest) {
        if (setAlarmStateRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)setAlarmStateRequest, "CloudWatchClient");
        request.addParameter("Action", "SetAlarmState");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (setAlarmStateRequest.alarmName() != null) {
            request.addParameter("AlarmName", StringUtils.fromString((String)setAlarmStateRequest.alarmName()));
        }
        if (setAlarmStateRequest.stateValueString() != null) {
            request.addParameter("StateValue", StringUtils.fromString((String)setAlarmStateRequest.stateValueString()));
        }
        if (setAlarmStateRequest.stateReason() != null) {
            request.addParameter("StateReason", StringUtils.fromString((String)setAlarmStateRequest.stateReason()));
        }
        if (setAlarmStateRequest.stateReasonData() != null) {
            request.addParameter("StateReasonData", StringUtils.fromString((String)setAlarmStateRequest.stateReasonData()));
        }
        return request;
    }
}

