/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.time.Instant;
import java.util.Optional;
import software.amazon.awssdk.services.cloudwatch.model.HistoryItemType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AlarmHistoryItem
implements ToCopyableBuilder<Builder, AlarmHistoryItem> {
    private final String alarmName;
    private final Instant timestamp;
    private final String historyItemType;
    private final String historySummary;
    private final String historyData;

    private AlarmHistoryItem(BuilderImpl builder) {
        this.alarmName = builder.alarmName;
        this.timestamp = builder.timestamp;
        this.historyItemType = builder.historyItemType;
        this.historySummary = builder.historySummary;
        this.historyData = builder.historyData;
    }

    public String alarmName() {
        return this.alarmName;
    }

    public Instant timestamp() {
        return this.timestamp;
    }

    public HistoryItemType historyItemType() {
        return HistoryItemType.fromValue(this.historyItemType);
    }

    public String historyItemTypeString() {
        return this.historyItemType;
    }

    public String historySummary() {
        return this.historySummary;
    }

    public String historyData() {
        return this.historyData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.alarmName() == null ? 0 : this.alarmName().hashCode());
        hashCode = 31 * hashCode + (this.timestamp() == null ? 0 : this.timestamp().hashCode());
        hashCode = 31 * hashCode + (this.historyItemTypeString() == null ? 0 : this.historyItemTypeString().hashCode());
        hashCode = 31 * hashCode + (this.historySummary() == null ? 0 : this.historySummary().hashCode());
        hashCode = 31 * hashCode + (this.historyData() == null ? 0 : this.historyData().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlarmHistoryItem)) {
            return false;
        }
        AlarmHistoryItem other = (AlarmHistoryItem)obj;
        if (other.alarmName() == null ^ this.alarmName() == null) {
            return false;
        }
        if (other.alarmName() != null && !other.alarmName().equals(this.alarmName())) {
            return false;
        }
        if (other.timestamp() == null ^ this.timestamp() == null) {
            return false;
        }
        if (other.timestamp() != null && !other.timestamp().equals(this.timestamp())) {
            return false;
        }
        if (other.historyItemTypeString() == null ^ this.historyItemTypeString() == null) {
            return false;
        }
        if (other.historyItemTypeString() != null && !other.historyItemTypeString().equals(this.historyItemTypeString())) {
            return false;
        }
        if (other.historySummary() == null ^ this.historySummary() == null) {
            return false;
        }
        if (other.historySummary() != null && !other.historySummary().equals(this.historySummary())) {
            return false;
        }
        if (other.historyData() == null ^ this.historyData() == null) {
            return false;
        }
        return other.historyData() == null || other.historyData().equals(this.historyData());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.alarmName() != null) {
            sb.append("AlarmName: ").append(this.alarmName()).append(",");
        }
        if (this.timestamp() != null) {
            sb.append("Timestamp: ").append(this.timestamp()).append(",");
        }
        if (this.historyItemTypeString() != null) {
            sb.append("HistoryItemType: ").append(this.historyItemTypeString()).append(",");
        }
        if (this.historySummary() != null) {
            sb.append("HistorySummary: ").append(this.historySummary()).append(",");
        }
        if (this.historyData() != null) {
            sb.append("HistoryData: ").append(this.historyData()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AlarmName": {
                return Optional.of(clazz.cast(this.alarmName()));
            }
            case "Timestamp": {
                return Optional.of(clazz.cast(this.timestamp()));
            }
            case "HistoryItemType": {
                return Optional.of(clazz.cast(this.historyItemTypeString()));
            }
            case "HistorySummary": {
                return Optional.of(clazz.cast(this.historySummary()));
            }
            case "HistoryData": {
                return Optional.of(clazz.cast(this.historyData()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String alarmName;
        private Instant timestamp;
        private String historyItemType;
        private String historySummary;
        private String historyData;

        private BuilderImpl() {
        }

        private BuilderImpl(AlarmHistoryItem model) {
            this.alarmName(model.alarmName);
            this.timestamp(model.timestamp);
            this.historyItemType(model.historyItemType);
            this.historySummary(model.historySummary);
            this.historyData(model.historyData);
        }

        public final String getAlarmName() {
            return this.alarmName;
        }

        @Override
        public final Builder alarmName(String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        public final void setAlarmName(String alarmName) {
            this.alarmName = alarmName;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public final String getHistoryItemType() {
            return this.historyItemType;
        }

        @Override
        public final Builder historyItemType(String historyItemType) {
            this.historyItemType = historyItemType;
            return this;
        }

        @Override
        public final Builder historyItemType(HistoryItemType historyItemType) {
            this.historyItemType(historyItemType.toString());
            return this;
        }

        public final void setHistoryItemType(String historyItemType) {
            this.historyItemType = historyItemType;
        }

        public final String getHistorySummary() {
            return this.historySummary;
        }

        @Override
        public final Builder historySummary(String historySummary) {
            this.historySummary = historySummary;
            return this;
        }

        public final void setHistorySummary(String historySummary) {
            this.historySummary = historySummary;
        }

        public final String getHistoryData() {
            return this.historyData;
        }

        @Override
        public final Builder historyData(String historyData) {
            this.historyData = historyData;
            return this;
        }

        public final void setHistoryData(String historyData) {
            this.historyData = historyData;
        }

        public AlarmHistoryItem build() {
            return new AlarmHistoryItem(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AlarmHistoryItem> {
        public Builder alarmName(String var1);

        public Builder timestamp(Instant var1);

        public Builder historyItemType(String var1);

        public Builder historyItemType(HistoryItemType var1);

        public Builder historySummary(String var1);

        public Builder historyData(String var1);
    }
}

