/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.cloudwatch.model.AlarmNamesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EnableAlarmActionsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, EnableAlarmActionsRequest> {
    private final List<String> alarmNames;

    private EnableAlarmActionsRequest(BuilderImpl builder) {
        this.alarmNames = builder.alarmNames;
    }

    public List<String> alarmNames() {
        return this.alarmNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.alarmNames() == null ? 0 : this.alarmNames().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableAlarmActionsRequest)) {
            return false;
        }
        EnableAlarmActionsRequest other = (EnableAlarmActionsRequest)((Object)obj);
        if (other.alarmNames() == null ^ this.alarmNames() == null) {
            return false;
        }
        return other.alarmNames() == null || other.alarmNames().equals(this.alarmNames());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.alarmNames() != null) {
            sb.append("AlarmNames: ").append(this.alarmNames()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> alarmNames;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableAlarmActionsRequest model) {
            this.setAlarmNames(model.alarmNames);
        }

        public final Collection<String> getAlarmNames() {
            return this.alarmNames;
        }

        @Override
        public final Builder alarmNames(Collection<String> alarmNames) {
            this.alarmNames = AlarmNamesCopier.copy(alarmNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmNames(String ... alarmNames) {
            this.alarmNames(Arrays.asList(alarmNames));
            return this;
        }

        public final void setAlarmNames(Collection<String> alarmNames) {
            this.alarmNames = AlarmNamesCopier.copy(alarmNames);
        }

        @SafeVarargs
        public final void setAlarmNames(String ... alarmNames) {
            this.alarmNames(Arrays.asList(alarmNames));
        }

        public EnableAlarmActionsRequest build() {
            return new EnableAlarmActionsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EnableAlarmActionsRequest> {
        public Builder alarmNames(Collection<String> var1);

        public Builder alarmNames(String ... var1);
    }
}

