/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.cloudwatch.model.DatapointValueMapCopier;
import software.amazon.awssdk.services.cloudwatch.model.StandardUnit;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Datapoint
implements ToCopyableBuilder<Builder, Datapoint> {
    private final Instant timestamp;
    private final Double sampleCount;
    private final Double average;
    private final Double sum;
    private final Double minimum;
    private final Double maximum;
    private final String unit;
    private final Map<String, Double> extendedStatistics;

    private Datapoint(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.sampleCount = builder.sampleCount;
        this.average = builder.average;
        this.sum = builder.sum;
        this.minimum = builder.minimum;
        this.maximum = builder.maximum;
        this.unit = builder.unit;
        this.extendedStatistics = builder.extendedStatistics;
    }

    public Instant timestamp() {
        return this.timestamp;
    }

    public Double sampleCount() {
        return this.sampleCount;
    }

    public Double average() {
        return this.average;
    }

    public Double sum() {
        return this.sum;
    }

    public Double minimum() {
        return this.minimum;
    }

    public Double maximum() {
        return this.maximum;
    }

    public StandardUnit unit() {
        return StandardUnit.fromValue(this.unit);
    }

    public String unitAsString() {
        return this.unit;
    }

    public Map<String, Double> extendedStatistics() {
        return this.extendedStatistics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.average());
        hashCode = 31 * hashCode + Objects.hashCode(this.sum());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimum());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximum());
        hashCode = 31 * hashCode + Objects.hashCode(this.unitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.extendedStatistics());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Datapoint)) {
            return false;
        }
        Datapoint other = (Datapoint)obj;
        return Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.sampleCount(), other.sampleCount()) && Objects.equals(this.average(), other.average()) && Objects.equals(this.sum(), other.sum()) && Objects.equals(this.minimum(), other.minimum()) && Objects.equals(this.maximum(), other.maximum()) && Objects.equals(this.unitAsString(), other.unitAsString()) && Objects.equals(this.extendedStatistics(), other.extendedStatistics());
    }

    public String toString() {
        return ToString.builder((String)"Datapoint").add("Timestamp", (Object)this.timestamp()).add("SampleCount", (Object)this.sampleCount()).add("Average", (Object)this.average()).add("Sum", (Object)this.sum()).add("Minimum", (Object)this.minimum()).add("Maximum", (Object)this.maximum()).add("Unit", (Object)this.unitAsString()).add("ExtendedStatistics", this.extendedStatistics()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Timestamp": {
                return Optional.of(clazz.cast(this.timestamp()));
            }
            case "SampleCount": {
                return Optional.of(clazz.cast(this.sampleCount()));
            }
            case "Average": {
                return Optional.of(clazz.cast(this.average()));
            }
            case "Sum": {
                return Optional.of(clazz.cast(this.sum()));
            }
            case "Minimum": {
                return Optional.of(clazz.cast(this.minimum()));
            }
            case "Maximum": {
                return Optional.of(clazz.cast(this.maximum()));
            }
            case "Unit": {
                return Optional.of(clazz.cast(this.unitAsString()));
            }
            case "ExtendedStatistics": {
                return Optional.of(clazz.cast(this.extendedStatistics()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Instant timestamp;
        private Double sampleCount;
        private Double average;
        private Double sum;
        private Double minimum;
        private Double maximum;
        private String unit;
        private Map<String, Double> extendedStatistics;

        private BuilderImpl() {
        }

        private BuilderImpl(Datapoint model) {
            this.timestamp(model.timestamp);
            this.sampleCount(model.sampleCount);
            this.average(model.average);
            this.sum(model.sum);
            this.minimum(model.minimum);
            this.maximum(model.maximum);
            this.unit(model.unit);
            this.extendedStatistics(model.extendedStatistics);
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public final Double getSampleCount() {
            return this.sampleCount;
        }

        @Override
        public final Builder sampleCount(Double sampleCount) {
            this.sampleCount = sampleCount;
            return this;
        }

        public final void setSampleCount(Double sampleCount) {
            this.sampleCount = sampleCount;
        }

        public final Double getAverage() {
            return this.average;
        }

        @Override
        public final Builder average(Double average) {
            this.average = average;
            return this;
        }

        public final void setAverage(Double average) {
            this.average = average;
        }

        public final Double getSum() {
            return this.sum;
        }

        @Override
        public final Builder sum(Double sum) {
            this.sum = sum;
            return this;
        }

        public final void setSum(Double sum) {
            this.sum = sum;
        }

        public final Double getMinimum() {
            return this.minimum;
        }

        @Override
        public final Builder minimum(Double minimum) {
            this.minimum = minimum;
            return this;
        }

        public final void setMinimum(Double minimum) {
            this.minimum = minimum;
        }

        public final Double getMaximum() {
            return this.maximum;
        }

        @Override
        public final Builder maximum(Double maximum) {
            this.maximum = maximum;
            return this;
        }

        public final void setMaximum(Double maximum) {
            this.maximum = maximum;
        }

        public final String getUnit() {
            return this.unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(StandardUnit unit) {
            this.unit(unit.toString());
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        public final Map<String, Double> getExtendedStatistics() {
            return this.extendedStatistics;
        }

        @Override
        public final Builder extendedStatistics(Map<String, Double> extendedStatistics) {
            this.extendedStatistics = DatapointValueMapCopier.copy(extendedStatistics);
            return this;
        }

        public final void setExtendedStatistics(Map<String, Double> extendedStatistics) {
            this.extendedStatistics = DatapointValueMapCopier.copy(extendedStatistics);
        }

        public Datapoint build() {
            return new Datapoint(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Datapoint> {
        public Builder timestamp(Instant var1);

        public Builder sampleCount(Double var1);

        public Builder average(Double var1);

        public Builder sum(Double var1);

        public Builder minimum(Double var1);

        public Builder maximum(Double var1);

        public Builder unit(String var1);

        public Builder unit(StandardUnit var1);

        public Builder extendedStatistics(Map<String, Double> var1);
    }
}

