/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.cloudwatch.model.AlarmHistoryItem;
import software.amazon.awssdk.services.cloudwatch.model.AlarmHistoryItemsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeAlarmHistoryResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeAlarmHistoryResponse> {
    private final List<AlarmHistoryItem> alarmHistoryItems;
    private final String nextToken;

    private DescribeAlarmHistoryResponse(BuilderImpl builder) {
        this.alarmHistoryItems = builder.alarmHistoryItems;
        this.nextToken = builder.nextToken;
    }

    public List<AlarmHistoryItem> alarmHistoryItems() {
        return this.alarmHistoryItems;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.alarmHistoryItems() == null ? 0 : this.alarmHistoryItems().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAlarmHistoryResponse)) {
            return false;
        }
        DescribeAlarmHistoryResponse other = (DescribeAlarmHistoryResponse)((Object)obj);
        if (other.alarmHistoryItems() == null ^ this.alarmHistoryItems() == null) {
            return false;
        }
        if (other.alarmHistoryItems() != null && !other.alarmHistoryItems().equals(this.alarmHistoryItems())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.alarmHistoryItems() != null) {
            sb.append("AlarmHistoryItems: ").append(this.alarmHistoryItems()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<AlarmHistoryItem> alarmHistoryItems = new SdkInternalList();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAlarmHistoryResponse model) {
            this.setAlarmHistoryItems(model.alarmHistoryItems);
            this.setNextToken(model.nextToken);
        }

        public final Collection<AlarmHistoryItem> getAlarmHistoryItems() {
            return this.alarmHistoryItems;
        }

        @Override
        public final Builder alarmHistoryItems(Collection<AlarmHistoryItem> alarmHistoryItems) {
            this.alarmHistoryItems = AlarmHistoryItemsCopier.copy(alarmHistoryItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmHistoryItems(AlarmHistoryItem ... alarmHistoryItems) {
            if (this.alarmHistoryItems == null) {
                this.alarmHistoryItems = new SdkInternalList(alarmHistoryItems.length);
            }
            for (AlarmHistoryItem e : alarmHistoryItems) {
                this.alarmHistoryItems.add(e);
            }
            return this;
        }

        public final void setAlarmHistoryItems(Collection<AlarmHistoryItem> alarmHistoryItems) {
            this.alarmHistoryItems = AlarmHistoryItemsCopier.copy(alarmHistoryItems);
        }

        @SafeVarargs
        public final void setAlarmHistoryItems(AlarmHistoryItem ... alarmHistoryItems) {
            if (this.alarmHistoryItems == null) {
                this.alarmHistoryItems = new SdkInternalList(alarmHistoryItems.length);
            }
            for (AlarmHistoryItem e : alarmHistoryItems) {
                this.alarmHistoryItems.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeAlarmHistoryResponse build() {
            return new DescribeAlarmHistoryResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeAlarmHistoryResponse> {
        public Builder alarmHistoryItems(Collection<AlarmHistoryItem> var1);

        public Builder alarmHistoryItems(AlarmHistoryItem ... var1);

        public Builder nextToken(String var1);
    }
}

