/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtraildata;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.cloudtraildata.model.PutAuditEventsRequest;
import software.amazon.awssdk.services.cloudtraildata.model.PutAuditEventsResponse;

/**
 * Service client for accessing AWS CloudTrail Data Service asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * The CloudTrail Data Service lets you ingest events into CloudTrail from any source in your hybrid environments, such
 * as in-house or SaaS applications hosted on-premises or in the cloud, virtual machines, or containers. You can store,
 * access, analyze, troubleshoot and take action on this data without maintaining multiple log aggregators and reporting
 * tools. After you run <code>PutAuditEvents</code> to ingest your application activity into CloudTrail, you can use
 * CloudTrail Lake to search, query, and analyze the data that is logged from your applications.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface CloudTrailDataAsyncClient extends AwsClient {
    String SERVICE_NAME = "cloudtrail-data";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "cloudtrail-data";

    /**
     * <p>
     * Ingests your application events into CloudTrail Lake. A required parameter, <code>auditEvents</code>, accepts the
     * JSON records (also called <i>payload</i>) of events that you want CloudTrail to ingest. You can add up to 100 of
     * these events (or up to 1 MB) per <code>PutAuditEvents</code> request.
     * </p>
     *
     * @param putAuditEventsRequest
     * @return A Java Future containing the result of the PutAuditEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ChannelInsufficientPermissionException The caller's account ID must be the same as the channel
     *         owner's account ID.</li>
     *         <li>ChannelNotFoundException The channel could not be found.</li>
     *         <li>InvalidChannelArnException The specified channel ARN is not a valid channel ARN.</li>
     *         <li>ChannelUnsupportedSchemaException The schema type of the event is not supported.</li>
     *         <li>DuplicatedAuditEventIdException Two or more entries in the request have the same event ID.</li>
     *         <li>UnsupportedOperationException The operation requested is not supported in this region or account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailDataException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudTrailDataAsyncClient.PutAuditEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-data-2021-08-11/PutAuditEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutAuditEventsResponse> putAuditEvents(PutAuditEventsRequest putAuditEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Ingests your application events into CloudTrail Lake. A required parameter, <code>auditEvents</code>, accepts the
     * JSON records (also called <i>payload</i>) of events that you want CloudTrail to ingest. You can add up to 100 of
     * these events (or up to 1 MB) per <code>PutAuditEvents</code> request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutAuditEventsRequest.Builder} avoiding the need to
     * create one manually via {@link PutAuditEventsRequest#builder()}
     * </p>
     *
     * @param putAuditEventsRequest
     *        A {@link Consumer} that will call methods on {@link PutAuditEventsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutAuditEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ChannelInsufficientPermissionException The caller's account ID must be the same as the channel
     *         owner's account ID.</li>
     *         <li>ChannelNotFoundException The channel could not be found.</li>
     *         <li>InvalidChannelArnException The specified channel ARN is not a valid channel ARN.</li>
     *         <li>ChannelUnsupportedSchemaException The schema type of the event is not supported.</li>
     *         <li>DuplicatedAuditEventIdException Two or more entries in the request have the same event ID.</li>
     *         <li>UnsupportedOperationException The operation requested is not supported in this region or account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailDataException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudTrailDataAsyncClient.PutAuditEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-data-2021-08-11/PutAuditEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutAuditEventsResponse> putAuditEvents(Consumer<PutAuditEventsRequest.Builder> putAuditEventsRequest) {
        return putAuditEvents(PutAuditEventsRequest.builder().applyMutation(putAuditEventsRequest).build());
    }

    @Override
    default CloudTrailDataServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link CloudTrailDataAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static CloudTrailDataAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CloudTrailDataAsyncClient}.
     */
    static CloudTrailDataAsyncClientBuilder builder() {
        return new DefaultCloudTrailDataAsyncClientBuilder();
    }
}
