/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudtrail.CloudTrailAsyncClient;
import software.amazon.awssdk.services.cloudtrail.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudtrail.model.Event;
import software.amazon.awssdk.services.cloudtrail.model.ListInsightsDataRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListInsightsDataResponse;

public class ListInsightsDataPublisher
implements SdkPublisher<ListInsightsDataResponse> {
    private final CloudTrailAsyncClient client;
    private final ListInsightsDataRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListInsightsDataPublisher(CloudTrailAsyncClient client, ListInsightsDataRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListInsightsDataPublisher(CloudTrailAsyncClient client, ListInsightsDataRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListInsightsDataResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListInsightsDataResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Event> events() {
        Function<ListInsightsDataResponse, Iterator> getIterator = response -> {
            if (response != null && response.events() != null) {
                return response.events().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListInsightsDataResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListInsightsDataResponseFetcher
    implements AsyncPageFetcher<ListInsightsDataResponse> {
        private ListInsightsDataResponseFetcher() {
        }

        public boolean hasNextPage(ListInsightsDataResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListInsightsDataResponse> nextPage(ListInsightsDataResponse previousPage) {
            if (previousPage == null) {
                return ListInsightsDataPublisher.this.client.listInsightsData(ListInsightsDataPublisher.this.firstRequest);
            }
            return ListInsightsDataPublisher.this.client.listInsightsData((ListInsightsDataRequest)((Object)ListInsightsDataPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

