/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Template {
    API_ACTIVITY("API_ACTIVITY"),
    RESOURCE_ACCESS("RESOURCE_ACCESS"),
    USER_ACTIONS("USER_ACTIONS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Template> VALUE_MAP;
    private final String value;

    private Template(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Template fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Template> knownValues() {
        EnumSet<Template> knownValues = EnumSet.allOf(Template.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Template.class, Template::toString);
    }
}

