/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PublicKey
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PublicKey> {
    private static final SdkField<SdkBytes> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).getter(PublicKey.getter(PublicKey::value)).setter(PublicKey.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<Instant> VALIDITY_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(PublicKey.getter(PublicKey::validityStartTime)).setter(PublicKey.setter(Builder::validityStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidityStartTime").build()}).build();
    private static final SdkField<Instant> VALIDITY_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(PublicKey.getter(PublicKey::validityEndTime)).setter(PublicKey.setter(Builder::validityEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidityEndTime").build()}).build();
    private static final SdkField<String> FINGERPRINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PublicKey.getter(PublicKey::fingerprint)).setter(PublicKey.setter(Builder::fingerprint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fingerprint").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, VALIDITY_START_TIME_FIELD, VALIDITY_END_TIME_FIELD, FINGERPRINT_FIELD));
    private static final long serialVersionUID = 1L;
    private final SdkBytes value;
    private final Instant validityStartTime;
    private final Instant validityEndTime;
    private final String fingerprint;

    private PublicKey(BuilderImpl builder) {
        this.value = builder.value;
        this.validityStartTime = builder.validityStartTime;
        this.validityEndTime = builder.validityEndTime;
        this.fingerprint = builder.fingerprint;
    }

    public SdkBytes value() {
        return this.value;
    }

    public Instant validityStartTime() {
        return this.validityStartTime;
    }

    public Instant validityEndTime() {
        return this.validityEndTime;
    }

    public String fingerprint() {
        return this.fingerprint;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.validityStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.validityEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.fingerprint());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublicKey)) {
            return false;
        }
        PublicKey other = (PublicKey)obj;
        return Objects.equals(this.value(), other.value()) && Objects.equals(this.validityStartTime(), other.validityStartTime()) && Objects.equals(this.validityEndTime(), other.validityEndTime()) && Objects.equals(this.fingerprint(), other.fingerprint());
    }

    public String toString() {
        return ToString.builder((String)"PublicKey").add("Value", (Object)this.value()).add("ValidityStartTime", (Object)this.validityStartTime()).add("ValidityEndTime", (Object)this.validityEndTime()).add("Fingerprint", (Object)this.fingerprint()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "ValidityStartTime": {
                return Optional.ofNullable(clazz.cast(this.validityStartTime()));
            }
            case "ValidityEndTime": {
                return Optional.ofNullable(clazz.cast(this.validityEndTime()));
            }
            case "Fingerprint": {
                return Optional.ofNullable(clazz.cast(this.fingerprint()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PublicKey, T> g) {
        return obj -> g.apply((PublicKey)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SdkBytes value;
        private Instant validityStartTime;
        private Instant validityEndTime;
        private String fingerprint;

        private BuilderImpl() {
        }

        private BuilderImpl(PublicKey model) {
            this.value(model.value);
            this.validityStartTime(model.validityStartTime);
            this.validityEndTime(model.validityEndTime);
            this.fingerprint(model.fingerprint);
        }

        public final ByteBuffer getValue() {
            return this.value == null ? null : this.value.asByteBuffer();
        }

        @Override
        public final Builder value(SdkBytes value) {
            this.value = StandardMemberCopier.copy((SdkBytes)value);
            return this;
        }

        public final void setValue(ByteBuffer value) {
            this.value(value == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)value));
        }

        public final Instant getValidityStartTime() {
            return this.validityStartTime;
        }

        @Override
        public final Builder validityStartTime(Instant validityStartTime) {
            this.validityStartTime = validityStartTime;
            return this;
        }

        public final void setValidityStartTime(Instant validityStartTime) {
            this.validityStartTime = validityStartTime;
        }

        public final Instant getValidityEndTime() {
            return this.validityEndTime;
        }

        @Override
        public final Builder validityEndTime(Instant validityEndTime) {
            this.validityEndTime = validityEndTime;
            return this;
        }

        public final void setValidityEndTime(Instant validityEndTime) {
            this.validityEndTime = validityEndTime;
        }

        public final String getFingerprint() {
            return this.fingerprint;
        }

        @Override
        public final Builder fingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public final void setFingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
        }

        public PublicKey build() {
            return new PublicKey(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PublicKey> {
        public Builder value(SdkBytes var1);

        public Builder validityStartTime(Instant var1);

        public Builder validityEndTime(Instant var1);

        public Builder fingerprint(String var1);
    }
}

