/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutEventSelectorsRequest extends CloudTrailRequest implements
        ToCopyableBuilder<PutEventSelectorsRequest.Builder, PutEventSelectorsRequest> {
    private static final SdkField<String> TRAIL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutEventSelectorsRequest::trailName)).setter(setter(Builder::trailName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrailName").build()).build();

    private static final SdkField<List<EventSelector>> EVENT_SELECTORS_FIELD = SdkField
            .<List<EventSelector>> builder(MarshallingType.LIST)
            .getter(getter(PutEventSelectorsRequest::eventSelectors))
            .setter(setter(Builder::eventSelectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSelectors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EventSelector> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventSelector::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAIL_NAME_FIELD,
            EVENT_SELECTORS_FIELD));

    private final String trailName;

    private final List<EventSelector> eventSelectors;

    private PutEventSelectorsRequest(BuilderImpl builder) {
        super(builder);
        this.trailName = builder.trailName;
        this.eventSelectors = builder.eventSelectors;
    }

    /**
     * <p>
     * Specifies the name of the trail or trail ARN. If you specify a trail name, the string must meet the following
     * requirements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     * </p>
     * </li>
     * <li>
     * <p>
     * Start with a letter or number, and end with a letter or number
     * </p>
     * </li>
     * <li>
     * <p>
     * Be between 3 and 128 characters
     * </p>
     * </li>
     * <li>
     * <p>
     * Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     * <code>my--namespace</code> are invalid.
     * </p>
     * </li>
     * <li>
     * <p>
     * Not be in IP address format (for example, 192.168.5.4)
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you specify a trail ARN, it must be in the format:
     * </p>
     * <p>
     * <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     * </p>
     * 
     * @return Specifies the name of the trail or trail ARN. If you specify a trail name, the string must meet the
     *         following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are invalid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you specify a trail ARN, it must be in the format:
     *         </p>
     *         <p>
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     */
    public String trailName() {
        return trailName;
    }

    /**
     * Returns true if the EventSelectors property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasEventSelectors() {
        return eventSelectors != null && !(eventSelectors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the settings for your event selectors. You can configure up to five event selectors for a trail.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEventSelectors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies the settings for your event selectors. You can configure up to five event selectors for a
     *         trail.
     */
    public List<EventSelector> eventSelectors() {
        return eventSelectors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trailName());
        hashCode = 31 * hashCode + Objects.hashCode(eventSelectors());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEventSelectorsRequest)) {
            return false;
        }
        PutEventSelectorsRequest other = (PutEventSelectorsRequest) obj;
        return Objects.equals(trailName(), other.trailName()) && Objects.equals(eventSelectors(), other.eventSelectors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutEventSelectorsRequest").add("TrailName", trailName()).add("EventSelectors", eventSelectors())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrailName":
            return Optional.ofNullable(clazz.cast(trailName()));
        case "EventSelectors":
            return Optional.ofNullable(clazz.cast(eventSelectors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutEventSelectorsRequest, T> g) {
        return obj -> g.apply((PutEventSelectorsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudTrailRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutEventSelectorsRequest> {
        /**
         * <p>
         * Specifies the name of the trail or trail ARN. If you specify a trail name, the string must meet the following
         * requirements:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
         * </p>
         * </li>
         * <li>
         * <p>
         * Start with a letter or number, and end with a letter or number
         * </p>
         * </li>
         * <li>
         * <p>
         * Be between 3 and 128 characters
         * </p>
         * </li>
         * <li>
         * <p>
         * Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
         * <code>my--namespace</code> are invalid.
         * </p>
         * </li>
         * <li>
         * <p>
         * Not be in IP address format (for example, 192.168.5.4)
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you specify a trail ARN, it must be in the format:
         * </p>
         * <p>
         * <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
         * </p>
         * 
         * @param trailName
         *        Specifies the name of the trail or trail ARN. If you specify a trail name, the string must meet the
         *        following requirements:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Start with a letter or number, and end with a letter or number
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Be between 3 and 128 characters
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
         *        <code>my--namespace</code> are invalid.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Not be in IP address format (for example, 192.168.5.4)
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you specify a trail ARN, it must be in the format:
         *        </p>
         *        <p>
         *        <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trailName(String trailName);

        /**
         * <p>
         * Specifies the settings for your event selectors. You can configure up to five event selectors for a trail.
         * </p>
         * 
         * @param eventSelectors
         *        Specifies the settings for your event selectors. You can configure up to five event selectors for a
         *        trail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSelectors(Collection<EventSelector> eventSelectors);

        /**
         * <p>
         * Specifies the settings for your event selectors. You can configure up to five event selectors for a trail.
         * </p>
         * 
         * @param eventSelectors
         *        Specifies the settings for your event selectors. You can configure up to five event selectors for a
         *        trail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSelectors(EventSelector... eventSelectors);

        /**
         * <p>
         * Specifies the settings for your event selectors. You can configure up to five event selectors for a trail.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EventSelector>.Builder} avoiding the need
         * to create one manually via {@link List<EventSelector>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EventSelector>.Builder#build()} is called immediately and
         * its result is passed to {@link #eventSelectors(List<EventSelector>)}.
         * 
         * @param eventSelectors
         *        a consumer that will call methods on {@link List<EventSelector>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventSelectors(List<EventSelector>)
         */
        Builder eventSelectors(Consumer<EventSelector.Builder>... eventSelectors);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudTrailRequest.BuilderImpl implements Builder {
        private String trailName;

        private List<EventSelector> eventSelectors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutEventSelectorsRequest model) {
            super(model);
            trailName(model.trailName);
            eventSelectors(model.eventSelectors);
        }

        public final String getTrailName() {
            return trailName;
        }

        @Override
        public final Builder trailName(String trailName) {
            this.trailName = trailName;
            return this;
        }

        public final void setTrailName(String trailName) {
            this.trailName = trailName;
        }

        public final Collection<EventSelector.Builder> getEventSelectors() {
            return eventSelectors != null ? eventSelectors.stream().map(EventSelector::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder eventSelectors(Collection<EventSelector> eventSelectors) {
            this.eventSelectors = EventSelectorsCopier.copy(eventSelectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventSelectors(EventSelector... eventSelectors) {
            eventSelectors(Arrays.asList(eventSelectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventSelectors(Consumer<EventSelector.Builder>... eventSelectors) {
            eventSelectors(Stream.of(eventSelectors).map(c -> EventSelector.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEventSelectors(Collection<EventSelector.BuilderImpl> eventSelectors) {
            this.eventSelectors = EventSelectorsCopier.copyFromBuilder(eventSelectors);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutEventSelectorsRequest build() {
            return new PutEventSelectorsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
