/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a returned public key.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PublicKey implements SdkPojo, Serializable, ToCopyableBuilder<PublicKey.Builder, PublicKey> {
    private static final SdkField<SdkBytes> VALUE_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .getter(getter(PublicKey::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<Instant> VALIDITY_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(PublicKey::validityStartTime)).setter(setter(Builder::validityStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidityStartTime").build()).build();

    private static final SdkField<Instant> VALIDITY_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(PublicKey::validityEndTime)).setter(setter(Builder::validityEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidityEndTime").build()).build();

    private static final SdkField<String> FINGERPRINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PublicKey::fingerprint)).setter(setter(Builder::fingerprint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fingerprint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD,
            VALIDITY_START_TIME_FIELD, VALIDITY_END_TIME_FIELD, FINGERPRINT_FIELD));

    private static final long serialVersionUID = 1L;

    private final SdkBytes value;

    private final Instant validityStartTime;

    private final Instant validityEndTime;

    private final String fingerprint;

    private PublicKey(BuilderImpl builder) {
        this.value = builder.value;
        this.validityStartTime = builder.validityStartTime;
        this.validityEndTime = builder.validityEndTime;
        this.fingerprint = builder.fingerprint;
    }

    /**
     * <p>
     * The DER encoded public key value in PKCS#1 format.
     * </p>
     * 
     * @return The DER encoded public key value in PKCS#1 format.
     */
    public SdkBytes value() {
        return value;
    }

    /**
     * <p>
     * The starting time of validity of the public key.
     * </p>
     * 
     * @return The starting time of validity of the public key.
     */
    public Instant validityStartTime() {
        return validityStartTime;
    }

    /**
     * <p>
     * The ending time of validity of the public key.
     * </p>
     * 
     * @return The ending time of validity of the public key.
     */
    public Instant validityEndTime() {
        return validityEndTime;
    }

    /**
     * <p>
     * The fingerprint of the public key.
     * </p>
     * 
     * @return The fingerprint of the public key.
     */
    public String fingerprint() {
        return fingerprint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(validityStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(validityEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(fingerprint());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublicKey)) {
            return false;
        }
        PublicKey other = (PublicKey) obj;
        return Objects.equals(value(), other.value()) && Objects.equals(validityStartTime(), other.validityStartTime())
                && Objects.equals(validityEndTime(), other.validityEndTime())
                && Objects.equals(fingerprint(), other.fingerprint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PublicKey").add("Value", value()).add("ValidityStartTime", validityStartTime())
                .add("ValidityEndTime", validityEndTime()).add("Fingerprint", fingerprint()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "ValidityStartTime":
            return Optional.ofNullable(clazz.cast(validityStartTime()));
        case "ValidityEndTime":
            return Optional.ofNullable(clazz.cast(validityEndTime()));
        case "Fingerprint":
            return Optional.ofNullable(clazz.cast(fingerprint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PublicKey, T> g) {
        return obj -> g.apply((PublicKey) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PublicKey> {
        /**
         * <p>
         * The DER encoded public key value in PKCS#1 format.
         * </p>
         * 
         * @param value
         *        The DER encoded public key value in PKCS#1 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(SdkBytes value);

        /**
         * <p>
         * The starting time of validity of the public key.
         * </p>
         * 
         * @param validityStartTime
         *        The starting time of validity of the public key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validityStartTime(Instant validityStartTime);

        /**
         * <p>
         * The ending time of validity of the public key.
         * </p>
         * 
         * @param validityEndTime
         *        The ending time of validity of the public key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validityEndTime(Instant validityEndTime);

        /**
         * <p>
         * The fingerprint of the public key.
         * </p>
         * 
         * @param fingerprint
         *        The fingerprint of the public key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fingerprint(String fingerprint);
    }

    static final class BuilderImpl implements Builder {
        private SdkBytes value;

        private Instant validityStartTime;

        private Instant validityEndTime;

        private String fingerprint;

        private BuilderImpl() {
        }

        private BuilderImpl(PublicKey model) {
            value(model.value);
            validityStartTime(model.validityStartTime);
            validityEndTime(model.validityEndTime);
            fingerprint(model.fingerprint);
        }

        public final ByteBuffer getValue() {
            return value == null ? null : value.asByteBuffer();
        }

        @Override
        public final Builder value(SdkBytes value) {
            this.value = StandardMemberCopier.copy(value);
            return this;
        }

        public final void setValue(ByteBuffer value) {
            value(value == null ? null : SdkBytes.fromByteBuffer(value));
        }

        public final Instant getValidityStartTime() {
            return validityStartTime;
        }

        @Override
        public final Builder validityStartTime(Instant validityStartTime) {
            this.validityStartTime = validityStartTime;
            return this;
        }

        public final void setValidityStartTime(Instant validityStartTime) {
            this.validityStartTime = validityStartTime;
        }

        public final Instant getValidityEndTime() {
            return validityEndTime;
        }

        @Override
        public final Builder validityEndTime(Instant validityEndTime) {
            this.validityEndTime = validityEndTime;
            return this;
        }

        public final void setValidityEndTime(Instant validityEndTime) {
            this.validityEndTime = validityEndTime;
        }

        public final String getFingerprint() {
            return fingerprint;
        }

        @Override
        public final Builder fingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public final void setFingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
        }

        @Override
        public PublicKey build() {
            return new PublicKey(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
