/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns the objects or data listed below if successful. Otherwise, returns an error.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTrailsResponse extends CloudTrailResponse implements
        ToCopyableBuilder<DescribeTrailsResponse.Builder, DescribeTrailsResponse> {
    private static final SdkField<List<Trail>> TRAIL_LIST_FIELD = SdkField
            .<List<Trail>> builder(MarshallingType.LIST)
            .getter(getter(DescribeTrailsResponse::trailList))
            .setter(setter(Builder::trailList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trailList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Trail> builder(MarshallingType.SDK_POJO)
                                            .constructor(Trail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAIL_LIST_FIELD));

    private final List<Trail> trailList;

    private DescribeTrailsResponse(BuilderImpl builder) {
        super(builder);
        this.trailList = builder.trailList;
    }

    /**
     * Returns true if the TrailList property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTrailList() {
        return trailList != null && !(trailList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of trail objects. Trail objects with string values are only returned if values for the objects exist in
     * a trail's configuration. For example, <code>SNSTopicName</code> and <code>SNSTopicARN</code> are only returned in
     * results if a trail is configured to send SNS notifications. Similarly, <code>KMSKeyId</code> only appears in
     * results if a trail's log files are encrypted with AWS KMS-managed keys.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTrailList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of trail objects. Trail objects with string values are only returned if values for the objects
     *         exist in a trail's configuration. For example, <code>SNSTopicName</code> and <code>SNSTopicARN</code> are
     *         only returned in results if a trail is configured to send SNS notifications. Similarly,
     *         <code>KMSKeyId</code> only appears in results if a trail's log files are encrypted with AWS KMS-managed
     *         keys.
     */
    public List<Trail> trailList() {
        return trailList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trailList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrailsResponse)) {
            return false;
        }
        DescribeTrailsResponse other = (DescribeTrailsResponse) obj;
        return Objects.equals(trailList(), other.trailList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeTrailsResponse").add("TrailList", trailList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "trailList":
            return Optional.ofNullable(clazz.cast(trailList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTrailsResponse, T> g) {
        return obj -> g.apply((DescribeTrailsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudTrailResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeTrailsResponse> {
        /**
         * <p>
         * The list of trail objects. Trail objects with string values are only returned if values for the objects exist
         * in a trail's configuration. For example, <code>SNSTopicName</code> and <code>SNSTopicARN</code> are only
         * returned in results if a trail is configured to send SNS notifications. Similarly, <code>KMSKeyId</code> only
         * appears in results if a trail's log files are encrypted with AWS KMS-managed keys.
         * </p>
         * 
         * @param trailList
         *        The list of trail objects. Trail objects with string values are only returned if values for the
         *        objects exist in a trail's configuration. For example, <code>SNSTopicName</code> and
         *        <code>SNSTopicARN</code> are only returned in results if a trail is configured to send SNS
         *        notifications. Similarly, <code>KMSKeyId</code> only appears in results if a trail's log files are
         *        encrypted with AWS KMS-managed keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trailList(Collection<Trail> trailList);

        /**
         * <p>
         * The list of trail objects. Trail objects with string values are only returned if values for the objects exist
         * in a trail's configuration. For example, <code>SNSTopicName</code> and <code>SNSTopicARN</code> are only
         * returned in results if a trail is configured to send SNS notifications. Similarly, <code>KMSKeyId</code> only
         * appears in results if a trail's log files are encrypted with AWS KMS-managed keys.
         * </p>
         * 
         * @param trailList
         *        The list of trail objects. Trail objects with string values are only returned if values for the
         *        objects exist in a trail's configuration. For example, <code>SNSTopicName</code> and
         *        <code>SNSTopicARN</code> are only returned in results if a trail is configured to send SNS
         *        notifications. Similarly, <code>KMSKeyId</code> only appears in results if a trail's log files are
         *        encrypted with AWS KMS-managed keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trailList(Trail... trailList);

        /**
         * <p>
         * The list of trail objects. Trail objects with string values are only returned if values for the objects exist
         * in a trail's configuration. For example, <code>SNSTopicName</code> and <code>SNSTopicARN</code> are only
         * returned in results if a trail is configured to send SNS notifications. Similarly, <code>KMSKeyId</code> only
         * appears in results if a trail's log files are encrypted with AWS KMS-managed keys.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Trail>.Builder} avoiding the need to create
         * one manually via {@link List<Trail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Trail>.Builder#build()} is called immediately and its result
         * is passed to {@link #trailList(List<Trail>)}.
         * 
         * @param trailList
         *        a consumer that will call methods on {@link List<Trail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trailList(List<Trail>)
         */
        Builder trailList(Consumer<Trail.Builder>... trailList);
    }

    static final class BuilderImpl extends CloudTrailResponse.BuilderImpl implements Builder {
        private List<Trail> trailList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrailsResponse model) {
            super(model);
            trailList(model.trailList);
        }

        public final Collection<Trail.Builder> getTrailList() {
            return trailList != null ? trailList.stream().map(Trail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder trailList(Collection<Trail> trailList) {
            this.trailList = TrailListCopier.copy(trailList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trailList(Trail... trailList) {
            trailList(Arrays.asList(trailList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trailList(Consumer<Trail.Builder>... trailList) {
            trailList(Stream.of(trailList).map(c -> Trail.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTrailList(Collection<Trail.BuilderImpl> trailList) {
            this.trailList = TrailListCopier.copyFromBuilder(trailList);
        }

        @Override
        public DescribeTrailsResponse build() {
            return new DescribeTrailsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
