/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearchdomain.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudsearchdomain.model.CloudSearchDomainResponse;
import software.amazon.awssdk.services.cloudsearchdomain.model.SuggestModel;
import software.amazon.awssdk.services.cloudsearchdomain.model.SuggestStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SuggestResponse
extends CloudSearchDomainResponse
implements ToCopyableBuilder<Builder, SuggestResponse> {
    private static final SdkField<SuggestStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("status").getter(SuggestResponse.getter(SuggestResponse::status)).setter(SuggestResponse.setter(Builder::status)).constructor(SuggestStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<SuggestModel> SUGGEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("suggest").getter(SuggestResponse.getter(SuggestResponse::suggest)).setter(SuggestResponse.setter(Builder::suggest)).constructor(SuggestModel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suggest").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, SUGGEST_FIELD));
    private final SuggestStatus status;
    private final SuggestModel suggest;

    private SuggestResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.suggest = builder.suggest;
    }

    public final SuggestStatus status() {
        return this.status;
    }

    public final SuggestModel suggest() {
        return this.suggest;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.suggest());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuggestResponse)) {
            return false;
        }
        SuggestResponse other = (SuggestResponse)((Object)obj);
        return Objects.equals(this.status(), other.status()) && Objects.equals(this.suggest(), other.suggest());
    }

    public final String toString() {
        return ToString.builder((String)"SuggestResponse").add("Status", (Object)this.status()).add("Suggest", (Object)this.suggest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "suggest": {
                return Optional.ofNullable(clazz.cast(this.suggest()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SuggestResponse, T> g) {
        return obj -> g.apply((SuggestResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudSearchDomainResponse.BuilderImpl
    implements Builder {
        private SuggestStatus status;
        private SuggestModel suggest;

        private BuilderImpl() {
        }

        private BuilderImpl(SuggestResponse model) {
            super(model);
            this.status(model.status);
            this.suggest(model.suggest);
        }

        public final SuggestStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(SuggestStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        @Transient
        public final Builder status(SuggestStatus status) {
            this.status = status;
            return this;
        }

        public final SuggestModel.Builder getSuggest() {
            return this.suggest != null ? this.suggest.toBuilder() : null;
        }

        public final void setSuggest(SuggestModel.BuilderImpl suggest) {
            this.suggest = suggest != null ? suggest.build() : null;
        }

        @Override
        @Transient
        public final Builder suggest(SuggestModel suggest) {
            this.suggest = suggest;
            return this;
        }

        @Override
        public SuggestResponse build() {
            return new SuggestResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudSearchDomainResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SuggestResponse> {
        public Builder status(SuggestStatus var1);

        default public Builder status(Consumer<SuggestStatus.Builder> status) {
            return this.status((SuggestStatus)((SuggestStatus.Builder)SuggestStatus.builder().applyMutation(status)).build());
        }

        public Builder suggest(SuggestModel var1);

        default public Builder suggest(Consumer<SuggestModel.Builder> suggest) {
            return this.suggest((SuggestModel)((SuggestModel.Builder)SuggestModel.builder().applyMutation(suggest)).build());
        }
    }
}

