/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearchdomain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An autocomplete suggestion that matches the query string specified in a <code>SuggestRequest</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SuggestionMatch implements SdkPojo, Serializable, ToCopyableBuilder<SuggestionMatch.Builder, SuggestionMatch> {
    private static final SdkField<String> SUGGESTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("suggestion").getter(getter(SuggestionMatch::suggestion)).setter(setter(Builder::suggestion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suggestion").build()).build();

    private static final SdkField<Long> SCORE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("score")
            .getter(getter(SuggestionMatch::score)).setter(setter(Builder::score))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("score").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(SuggestionMatch::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUGGESTION_FIELD, SCORE_FIELD,
            ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String suggestion;

    private final Long score;

    private final String id;

    private SuggestionMatch(BuilderImpl builder) {
        this.suggestion = builder.suggestion;
        this.score = builder.score;
        this.id = builder.id;
    }

    /**
     * <p>
     * The string that matches the query string specified in the <code>SuggestRequest</code>.
     * </p>
     * 
     * @return The string that matches the query string specified in the <code>SuggestRequest</code>.
     */
    public final String suggestion() {
        return suggestion;
    }

    /**
     * <p>
     * The relevance score of a suggested match.
     * </p>
     * 
     * @return The relevance score of a suggested match.
     */
    public final Long score() {
        return score;
    }

    /**
     * <p>
     * The document ID of the suggested document.
     * </p>
     * 
     * @return The document ID of the suggested document.
     */
    public final String id() {
        return id;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(suggestion());
        hashCode = 31 * hashCode + Objects.hashCode(score());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuggestionMatch)) {
            return false;
        }
        SuggestionMatch other = (SuggestionMatch) obj;
        return Objects.equals(suggestion(), other.suggestion()) && Objects.equals(score(), other.score())
                && Objects.equals(id(), other.id());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SuggestionMatch").add("Suggestion", suggestion()).add("Score", score()).add("Id", id()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "suggestion":
            return Optional.ofNullable(clazz.cast(suggestion()));
        case "score":
            return Optional.ofNullable(clazz.cast(score()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SuggestionMatch, T> g) {
        return obj -> g.apply((SuggestionMatch) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SuggestionMatch> {
        /**
         * <p>
         * The string that matches the query string specified in the <code>SuggestRequest</code>.
         * </p>
         * 
         * @param suggestion
         *        The string that matches the query string specified in the <code>SuggestRequest</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suggestion(String suggestion);

        /**
         * <p>
         * The relevance score of a suggested match.
         * </p>
         * 
         * @param score
         *        The relevance score of a suggested match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder score(Long score);

        /**
         * <p>
         * The document ID of the suggested document.
         * </p>
         * 
         * @param id
         *        The document ID of the suggested document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);
    }

    static final class BuilderImpl implements Builder {
        private String suggestion;

        private Long score;

        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(SuggestionMatch model) {
            suggestion(model.suggestion);
            score(model.score);
            id(model.id);
        }

        public final String getSuggestion() {
            return suggestion;
        }

        @Override
        public final Builder suggestion(String suggestion) {
            this.suggestion = suggestion;
            return this;
        }

        public final void setSuggestion(String suggestion) {
            this.suggestion = suggestion;
        }

        public final Long getScore() {
            return score;
        }

        @Override
        public final Builder score(Long score) {
            this.score = score;
            return this;
        }

        public final void setScore(Long score) {
            this.score = score;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public SuggestionMatch build() {
            return new SuggestionMatch(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
