/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearchdomain.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum QueryParser {
    SIMPLE("simple"),
    STRUCTURED("structured"),
    LUCENE("lucene"),
    DISMAX("dismax"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private QueryParser(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static QueryParser fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(QueryParser.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<QueryParser> knownValues() {
        return Stream.of(QueryParser.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

