/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearchdomain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The collection of documents that match the search request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Hits implements SdkPojo, Serializable, ToCopyableBuilder<Hits.Builder, Hits> {
    private static final SdkField<Long> FOUND_FIELD = SdkField.<Long> builder(MarshallingType.LONG).getter(getter(Hits::found))
            .setter(setter(Builder::found))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("found").build()).build();

    private static final SdkField<Long> START_FIELD = SdkField.<Long> builder(MarshallingType.LONG).getter(getter(Hits::start))
            .setter(setter(Builder::start))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("start").build()).build();

    private static final SdkField<String> CURSOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Hits::cursor)).setter(setter(Builder::cursor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cursor").build()).build();

    private static final SdkField<List<Hit>> HIT_FIELD = SdkField
            .<List<Hit>> builder(MarshallingType.LIST)
            .getter(getter(Hits::hit))
            .setter(setter(Builder::hit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hit").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Hit> builder(MarshallingType.SDK_POJO)
                                            .constructor(Hit::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FOUND_FIELD, START_FIELD,
            CURSOR_FIELD, HIT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long found;

    private final Long start;

    private final String cursor;

    private final List<Hit> hit;

    private Hits(BuilderImpl builder) {
        this.found = builder.found;
        this.start = builder.start;
        this.cursor = builder.cursor;
        this.hit = builder.hit;
    }

    /**
     * <p>
     * The total number of documents that match the search request.
     * </p>
     * 
     * @return The total number of documents that match the search request.
     */
    public Long found() {
        return found;
    }

    /**
     * <p>
     * The index of the first matching document.
     * </p>
     * 
     * @return The index of the first matching document.
     */
    public Long start() {
        return start;
    }

    /**
     * <p>
     * A cursor that can be used to retrieve the next set of matching documents when you want to page through a large
     * result set.
     * </p>
     * 
     * @return A cursor that can be used to retrieve the next set of matching documents when you want to page through a
     *         large result set.
     */
    public String cursor() {
        return cursor;
    }

    /**
     * Returns true if the Hit property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasHit() {
        return hit != null && !(hit instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A document that matches the search request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasHit()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A document that matches the search request.
     */
    public List<Hit> hit() {
        return hit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(found());
        hashCode = 31 * hashCode + Objects.hashCode(start());
        hashCode = 31 * hashCode + Objects.hashCode(cursor());
        hashCode = 31 * hashCode + Objects.hashCode(hit());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Hits)) {
            return false;
        }
        Hits other = (Hits) obj;
        return Objects.equals(found(), other.found()) && Objects.equals(start(), other.start())
                && Objects.equals(cursor(), other.cursor()) && Objects.equals(hit(), other.hit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Hits").add("Found", found()).add("Start", start()).add("Cursor", cursor()).add("Hit", hit())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "found":
            return Optional.ofNullable(clazz.cast(found()));
        case "start":
            return Optional.ofNullable(clazz.cast(start()));
        case "cursor":
            return Optional.ofNullable(clazz.cast(cursor()));
        case "hit":
            return Optional.ofNullable(clazz.cast(hit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Hits, T> g) {
        return obj -> g.apply((Hits) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Hits> {
        /**
         * <p>
         * The total number of documents that match the search request.
         * </p>
         * 
         * @param found
         *        The total number of documents that match the search request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder found(Long found);

        /**
         * <p>
         * The index of the first matching document.
         * </p>
         * 
         * @param start
         *        The index of the first matching document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder start(Long start);

        /**
         * <p>
         * A cursor that can be used to retrieve the next set of matching documents when you want to page through a
         * large result set.
         * </p>
         * 
         * @param cursor
         *        A cursor that can be used to retrieve the next set of matching documents when you want to page through
         *        a large result set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cursor(String cursor);

        /**
         * <p>
         * A document that matches the search request.
         * </p>
         * 
         * @param hit
         *        A document that matches the search request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hit(Collection<Hit> hit);

        /**
         * <p>
         * A document that matches the search request.
         * </p>
         * 
         * @param hit
         *        A document that matches the search request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hit(Hit... hit);

        /**
         * <p>
         * A document that matches the search request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Hit>.Builder} avoiding the need to create
         * one manually via {@link List<Hit>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Hit>.Builder#build()} is called immediately and its result
         * is passed to {@link #hit(List<Hit>)}.
         * 
         * @param hit
         *        a consumer that will call methods on {@link List<Hit>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hit(List<Hit>)
         */
        Builder hit(Consumer<Hit.Builder>... hit);
    }

    static final class BuilderImpl implements Builder {
        private Long found;

        private Long start;

        private String cursor;

        private List<Hit> hit = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Hits model) {
            found(model.found);
            start(model.start);
            cursor(model.cursor);
            hit(model.hit);
        }

        public final Long getFound() {
            return found;
        }

        @Override
        public final Builder found(Long found) {
            this.found = found;
            return this;
        }

        public final void setFound(Long found) {
            this.found = found;
        }

        public final Long getStart() {
            return start;
        }

        @Override
        public final Builder start(Long start) {
            this.start = start;
            return this;
        }

        public final void setStart(Long start) {
            this.start = start;
        }

        public final String getCursor() {
            return cursor;
        }

        @Override
        public final Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public final void setCursor(String cursor) {
            this.cursor = cursor;
        }

        public final Collection<Hit.Builder> getHit() {
            return hit != null ? hit.stream().map(Hit::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder hit(Collection<Hit> hit) {
            this.hit = HitListCopier.copy(hit);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hit(Hit... hit) {
            hit(Arrays.asList(hit));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hit(Consumer<Hit.Builder>... hit) {
            hit(Stream.of(hit).map(c -> Hit.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setHit(Collection<Hit.BuilderImpl> hit) {
            this.hit = HitListCopier.copyFromBuilder(hit);
        }

        @Override
        public Hits build() {
            return new Hits(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
