/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearchdomain.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudsearchdomain.model.FieldStats;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class FieldStatsMarshaller {
    private static final MarshallingInfo<String> MIN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("min").isBinary(false).build();
    private static final MarshallingInfo<String> MAX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("max").isBinary(false).build();
    private static final MarshallingInfo<Long> COUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("count").isBinary(false).build();
    private static final MarshallingInfo<Long> MISSING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("missing").isBinary(false).build();
    private static final MarshallingInfo<Double> SUM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sum").isBinary(false).build();
    private static final MarshallingInfo<Double> SUMOFSQUARES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sumOfSquares").isBinary(false).build();
    private static final MarshallingInfo<String> MEAN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mean").isBinary(false).build();
    private static final MarshallingInfo<Double> STDDEV_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stddev").isBinary(false).build();
    private static final FieldStatsMarshaller INSTANCE = new FieldStatsMarshaller();

    private FieldStatsMarshaller() {
    }

    public static FieldStatsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(FieldStats fieldStats, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)fieldStats, (String)"fieldStats");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)fieldStats.min(), MIN_BINDING);
            protocolMarshaller.marshall((Object)fieldStats.max(), MAX_BINDING);
            protocolMarshaller.marshall((Object)fieldStats.count(), COUNT_BINDING);
            protocolMarshaller.marshall((Object)fieldStats.missing(), MISSING_BINDING);
            protocolMarshaller.marshall((Object)fieldStats.sum(), SUM_BINDING);
            protocolMarshaller.marshall((Object)fieldStats.sumOfSquares(), SUMOFSQUARES_BINDING);
            protocolMarshaller.marshall((Object)fieldStats.mean(), MEAN_BINDING);
            protocolMarshaller.marshall((Object)fieldStats.stddev(), STDDEV_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

