/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearchdomain.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.cloudsearchdomain.model.CloudSearchDomainResponse;
import software.amazon.awssdk.services.cloudsearchdomain.model.SuggestModel;
import software.amazon.awssdk.services.cloudsearchdomain.model.SuggestStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SuggestResponse
extends CloudSearchDomainResponse
implements ToCopyableBuilder<Builder, SuggestResponse> {
    private final SuggestStatus status;
    private final SuggestModel suggest;

    private SuggestResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.suggest = builder.suggest;
    }

    public SuggestStatus status() {
        return this.status;
    }

    public SuggestModel suggest() {
        return this.suggest;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.suggest());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuggestResponse)) {
            return false;
        }
        SuggestResponse other = (SuggestResponse)((Object)obj);
        return Objects.equals(this.status(), other.status()) && Objects.equals(this.suggest(), other.suggest());
    }

    public String toString() {
        return ToString.builder((String)"SuggestResponse").add("Status", (Object)this.status()).add("Suggest", (Object)this.suggest()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "suggest": {
                return Optional.ofNullable(clazz.cast(this.suggest()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudSearchDomainResponse.BuilderImpl
    implements Builder {
        private SuggestStatus status;
        private SuggestModel suggest;

        private BuilderImpl() {
        }

        private BuilderImpl(SuggestResponse model) {
            super(model);
            this.status(model.status);
            this.suggest(model.suggest);
        }

        public final SuggestStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        @Override
        public final Builder status(SuggestStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(SuggestStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public final SuggestModel.Builder getSuggest() {
            return this.suggest != null ? this.suggest.toBuilder() : null;
        }

        @Override
        public final Builder suggest(SuggestModel suggest) {
            this.suggest = suggest;
            return this;
        }

        public final void setSuggest(SuggestModel.BuilderImpl suggest) {
            this.suggest = suggest != null ? suggest.build() : null;
        }

        @Override
        public SuggestResponse build() {
            return new SuggestResponse(this);
        }
    }

    public static interface Builder
    extends CloudSearchDomainResponse.Builder,
    CopyableBuilder<Builder, SuggestResponse> {
        public Builder status(SuggestStatus var1);

        default public Builder status(Consumer<SuggestStatus.Builder> status) {
            return this.status((SuggestStatus)((SuggestStatus.Builder)SuggestStatus.builder().applyMutation(status)).build());
        }

        public Builder suggest(SuggestModel var1);

        default public Builder suggest(Consumer<SuggestModel.Builder> suggest) {
            return this.suggest((SuggestModel)((SuggestModel.Builder)SuggestModel.builder().applyMutation(suggest)).build());
        }
    }
}

