/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudsearch.model.CloudSearchResponse;
import software.amazon.awssdk.services.cloudsearch.model.ScalingParametersStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateScalingParametersResponse
extends CloudSearchResponse
implements ToCopyableBuilder<Builder, UpdateScalingParametersResponse> {
    private static final SdkField<ScalingParametersStatus> SCALING_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateScalingParametersResponse.getter(UpdateScalingParametersResponse::scalingParameters)).setter(UpdateScalingParametersResponse.setter(Builder::scalingParameters)).constructor(ScalingParametersStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingParameters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALING_PARAMETERS_FIELD));
    private final ScalingParametersStatus scalingParameters;

    private UpdateScalingParametersResponse(BuilderImpl builder) {
        super(builder);
        this.scalingParameters = builder.scalingParameters;
    }

    public ScalingParametersStatus scalingParameters() {
        return this.scalingParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingParameters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateScalingParametersResponse)) {
            return false;
        }
        UpdateScalingParametersResponse other = (UpdateScalingParametersResponse)((Object)obj);
        return Objects.equals(this.scalingParameters(), other.scalingParameters());
    }

    public String toString() {
        return ToString.builder((String)"UpdateScalingParametersResponse").add("ScalingParameters", (Object)this.scalingParameters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScalingParameters": {
                return Optional.ofNullable(clazz.cast(this.scalingParameters()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateScalingParametersResponse, T> g) {
        return obj -> g.apply((UpdateScalingParametersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudSearchResponse.BuilderImpl
    implements Builder {
        private ScalingParametersStatus scalingParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateScalingParametersResponse model) {
            super(model);
            this.scalingParameters(model.scalingParameters);
        }

        public final ScalingParametersStatus.Builder getScalingParameters() {
            return this.scalingParameters != null ? this.scalingParameters.toBuilder() : null;
        }

        @Override
        public final Builder scalingParameters(ScalingParametersStatus scalingParameters) {
            this.scalingParameters = scalingParameters;
            return this;
        }

        public final void setScalingParameters(ScalingParametersStatus.BuilderImpl scalingParameters) {
            this.scalingParameters = scalingParameters != null ? scalingParameters.build() : null;
        }

        @Override
        public UpdateScalingParametersResponse build() {
            return new UpdateScalingParametersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudSearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateScalingParametersResponse> {
        public Builder scalingParameters(ScalingParametersStatus var1);

        default public Builder scalingParameters(Consumer<ScalingParametersStatus.Builder> scalingParameters) {
            return this.scalingParameters((ScalingParametersStatus)((ScalingParametersStatus.Builder)ScalingParametersStatus.builder().applyMutation(scalingParameters)).build());
        }
    }
}

