/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudsearch.model.CloudSearchResponse;
import software.amazon.awssdk.services.cloudsearch.model.ExpressionStatus;
import software.amazon.awssdk.services.cloudsearch.model.ExpressionStatusListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeExpressionsResponse
extends CloudSearchResponse
implements ToCopyableBuilder<Builder, DescribeExpressionsResponse> {
    private static final SdkField<List<ExpressionStatus>> EXPRESSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Expressions").getter(DescribeExpressionsResponse.getter(DescribeExpressionsResponse::expressions)).setter(DescribeExpressionsResponse.setter(Builder::expressions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expressions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExpressionStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPRESSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeExpressionsResponse.memberNameToFieldInitializer();
    private final List<ExpressionStatus> expressions;

    private DescribeExpressionsResponse(BuilderImpl builder) {
        super(builder);
        this.expressions = builder.expressions;
    }

    public final boolean hasExpressions() {
        return this.expressions != null && !(this.expressions instanceof SdkAutoConstructList);
    }

    public final List<ExpressionStatus> expressions() {
        return this.expressions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExpressions() ? this.expressions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeExpressionsResponse)) {
            return false;
        }
        DescribeExpressionsResponse other = (DescribeExpressionsResponse)((Object)obj);
        return this.hasExpressions() == other.hasExpressions() && Objects.equals(this.expressions(), other.expressions());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeExpressionsResponse").add("Expressions", this.hasExpressions() ? this.expressions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Expressions": {
                return Optional.ofNullable(clazz.cast(this.expressions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<ExpressionStatus>>> map = new HashMap<String, SdkField<List<ExpressionStatus>>>();
        map.put("Expressions", EXPRESSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeExpressionsResponse, T> g) {
        return obj -> g.apply((DescribeExpressionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudSearchResponse.BuilderImpl
    implements Builder {
        private List<ExpressionStatus> expressions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeExpressionsResponse model) {
            super(model);
            this.expressions(model.expressions);
        }

        public final List<ExpressionStatus.Builder> getExpressions() {
            List<ExpressionStatus.Builder> result = ExpressionStatusListCopier.copyToBuilder(this.expressions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExpressions(Collection<ExpressionStatus.BuilderImpl> expressions) {
            this.expressions = ExpressionStatusListCopier.copyFromBuilder(expressions);
        }

        @Override
        public final Builder expressions(Collection<ExpressionStatus> expressions) {
            this.expressions = ExpressionStatusListCopier.copy(expressions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expressions(ExpressionStatus ... expressions) {
            this.expressions(Arrays.asList(expressions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expressions(Consumer<ExpressionStatus.Builder> ... expressions) {
            this.expressions(Stream.of(expressions).map(c -> (ExpressionStatus)((ExpressionStatus.Builder)ExpressionStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeExpressionsResponse build() {
            return new DescribeExpressionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudSearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeExpressionsResponse> {
        public Builder expressions(Collection<ExpressionStatus> var1);

        public Builder expressions(ExpressionStatus ... var1);

        public Builder expressions(Consumer<ExpressionStatus.Builder> ... var1);
    }
}

