/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudsearch.model.CloudSearchRequest;
import software.amazon.awssdk.services.cloudsearch.model.StandardNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAnalysisSchemesRequest
extends CloudSearchRequest
implements ToCopyableBuilder<Builder, DescribeAnalysisSchemesRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(DescribeAnalysisSchemesRequest.getter(DescribeAnalysisSchemesRequest::domainName)).setter(DescribeAnalysisSchemesRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<List<String>> ANALYSIS_SCHEME_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AnalysisSchemeNames").getter(DescribeAnalysisSchemesRequest.getter(DescribeAnalysisSchemesRequest::analysisSchemeNames)).setter(DescribeAnalysisSchemesRequest.setter(Builder::analysisSchemeNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisSchemeNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DEPLOYED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Deployed").getter(DescribeAnalysisSchemesRequest.getter(DescribeAnalysisSchemesRequest::deployed)).setter(DescribeAnalysisSchemesRequest.setter(Builder::deployed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Deployed").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, ANALYSIS_SCHEME_NAMES_FIELD, DEPLOYED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeAnalysisSchemesRequest.memberNameToFieldInitializer();
    private final String domainName;
    private final List<String> analysisSchemeNames;
    private final Boolean deployed;

    private DescribeAnalysisSchemesRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.analysisSchemeNames = builder.analysisSchemeNames;
        this.deployed = builder.deployed;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final boolean hasAnalysisSchemeNames() {
        return this.analysisSchemeNames != null && !(this.analysisSchemeNames instanceof SdkAutoConstructList);
    }

    public final List<String> analysisSchemeNames() {
        return this.analysisSchemeNames;
    }

    public final Boolean deployed() {
        return this.deployed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnalysisSchemeNames() ? this.analysisSchemeNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.deployed());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAnalysisSchemesRequest)) {
            return false;
        }
        DescribeAnalysisSchemesRequest other = (DescribeAnalysisSchemesRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && this.hasAnalysisSchemeNames() == other.hasAnalysisSchemeNames() && Objects.equals(this.analysisSchemeNames(), other.analysisSchemeNames()) && Objects.equals(this.deployed(), other.deployed());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAnalysisSchemesRequest").add("DomainName", (Object)this.domainName()).add("AnalysisSchemeNames", this.hasAnalysisSchemeNames() ? this.analysisSchemeNames() : null).add("Deployed", (Object)this.deployed()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "AnalysisSchemeNames": {
                return Optional.ofNullable(clazz.cast(this.analysisSchemeNames()));
            }
            case "Deployed": {
                return Optional.ofNullable(clazz.cast(this.deployed()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("AnalysisSchemeNames", ANALYSIS_SCHEME_NAMES_FIELD);
        map.put("Deployed", DEPLOYED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAnalysisSchemesRequest, T> g) {
        return obj -> g.apply((DescribeAnalysisSchemesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudSearchRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private List<String> analysisSchemeNames = DefaultSdkAutoConstructList.getInstance();
        private Boolean deployed;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAnalysisSchemesRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.analysisSchemeNames(model.analysisSchemeNames);
            this.deployed(model.deployed);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final Collection<String> getAnalysisSchemeNames() {
            if (this.analysisSchemeNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.analysisSchemeNames;
        }

        public final void setAnalysisSchemeNames(Collection<String> analysisSchemeNames) {
            this.analysisSchemeNames = StandardNameListCopier.copy(analysisSchemeNames);
        }

        @Override
        public final Builder analysisSchemeNames(Collection<String> analysisSchemeNames) {
            this.analysisSchemeNames = StandardNameListCopier.copy(analysisSchemeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisSchemeNames(String ... analysisSchemeNames) {
            this.analysisSchemeNames(Arrays.asList(analysisSchemeNames));
            return this;
        }

        public final Boolean getDeployed() {
            return this.deployed;
        }

        public final void setDeployed(Boolean deployed) {
            this.deployed = deployed;
        }

        @Override
        public final Builder deployed(Boolean deployed) {
            this.deployed = deployed;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAnalysisSchemesRequest build() {
            return new DescribeAnalysisSchemesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudSearchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAnalysisSchemesRequest> {
        public Builder domainName(String var1);

        public Builder analysisSchemeNames(Collection<String> var1);

        public Builder analysisSchemeNames(String ... var1);

        public Builder deployed(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

