/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudsearch.model.CloudSearchRequest;
import software.amazon.awssdk.services.cloudsearch.model.StandardNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeExpressionsRequest
extends CloudSearchRequest
implements ToCopyableBuilder<Builder, DescribeExpressionsRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(DescribeExpressionsRequest.getter(DescribeExpressionsRequest::domainName)).setter(DescribeExpressionsRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<List<String>> EXPRESSION_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExpressionNames").getter(DescribeExpressionsRequest.getter(DescribeExpressionsRequest::expressionNames)).setter(DescribeExpressionsRequest.setter(Builder::expressionNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpressionNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DEPLOYED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Deployed").getter(DescribeExpressionsRequest.getter(DescribeExpressionsRequest::deployed)).setter(DescribeExpressionsRequest.setter(Builder::deployed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Deployed").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, EXPRESSION_NAMES_FIELD, DEPLOYED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DomainName", DOMAIN_NAME_FIELD);
            this.put("ExpressionNames", EXPRESSION_NAMES_FIELD);
            this.put("Deployed", DEPLOYED_FIELD);
        }
    });
    private final String domainName;
    private final List<String> expressionNames;
    private final Boolean deployed;

    private DescribeExpressionsRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.expressionNames = builder.expressionNames;
        this.deployed = builder.deployed;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final boolean hasExpressionNames() {
        return this.expressionNames != null && !(this.expressionNames instanceof SdkAutoConstructList);
    }

    public final List<String> expressionNames() {
        return this.expressionNames;
    }

    public final Boolean deployed() {
        return this.deployed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExpressionNames() ? this.expressionNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.deployed());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeExpressionsRequest)) {
            return false;
        }
        DescribeExpressionsRequest other = (DescribeExpressionsRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && this.hasExpressionNames() == other.hasExpressionNames() && Objects.equals(this.expressionNames(), other.expressionNames()) && Objects.equals(this.deployed(), other.deployed());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeExpressionsRequest").add("DomainName", (Object)this.domainName()).add("ExpressionNames", this.hasExpressionNames() ? this.expressionNames() : null).add("Deployed", (Object)this.deployed()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "ExpressionNames": {
                return Optional.ofNullable(clazz.cast(this.expressionNames()));
            }
            case "Deployed": {
                return Optional.ofNullable(clazz.cast(this.deployed()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeExpressionsRequest, T> g) {
        return obj -> g.apply((DescribeExpressionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudSearchRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private List<String> expressionNames = DefaultSdkAutoConstructList.getInstance();
        private Boolean deployed;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeExpressionsRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.expressionNames(model.expressionNames);
            this.deployed(model.deployed);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final Collection<String> getExpressionNames() {
            if (this.expressionNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.expressionNames;
        }

        public final void setExpressionNames(Collection<String> expressionNames) {
            this.expressionNames = StandardNameListCopier.copy(expressionNames);
        }

        @Override
        public final Builder expressionNames(Collection<String> expressionNames) {
            this.expressionNames = StandardNameListCopier.copy(expressionNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expressionNames(String ... expressionNames) {
            this.expressionNames(Arrays.asList(expressionNames));
            return this;
        }

        public final Boolean getDeployed() {
            return this.deployed;
        }

        public final void setDeployed(Boolean deployed) {
            this.deployed = deployed;
        }

        @Override
        public final Builder deployed(Boolean deployed) {
            this.deployed = deployed;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeExpressionsRequest build() {
            return new DescribeExpressionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudSearchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeExpressionsRequest> {
        public Builder domainName(String var1);

        public Builder expressionNames(Collection<String> var1);

        public Builder expressionNames(String ... var1);

        public Builder deployed(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

