/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudsearch.model.CloudSearchResponse;
import software.amazon.awssdk.services.cloudsearch.model.IndexFieldStatus;
import software.amazon.awssdk.services.cloudsearch.model.IndexFieldStatusListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeIndexFieldsResponse
extends CloudSearchResponse
implements ToCopyableBuilder<Builder, DescribeIndexFieldsResponse> {
    private static final SdkField<List<IndexFieldStatus>> INDEX_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IndexFields").getter(DescribeIndexFieldsResponse.getter(DescribeIndexFieldsResponse::indexFields)).setter(DescribeIndexFieldsResponse.setter(Builder::indexFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexFields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IndexFieldStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_FIELDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("IndexFields", INDEX_FIELDS_FIELD);
        }
    });
    private final List<IndexFieldStatus> indexFields;

    private DescribeIndexFieldsResponse(BuilderImpl builder) {
        super(builder);
        this.indexFields = builder.indexFields;
    }

    public final boolean hasIndexFields() {
        return this.indexFields != null && !(this.indexFields instanceof SdkAutoConstructList);
    }

    public final List<IndexFieldStatus> indexFields() {
        return this.indexFields;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIndexFields() ? this.indexFields() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIndexFieldsResponse)) {
            return false;
        }
        DescribeIndexFieldsResponse other = (DescribeIndexFieldsResponse)((Object)obj);
        return this.hasIndexFields() == other.hasIndexFields() && Objects.equals(this.indexFields(), other.indexFields());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeIndexFieldsResponse").add("IndexFields", this.hasIndexFields() ? this.indexFields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndexFields": {
                return Optional.ofNullable(clazz.cast(this.indexFields()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeIndexFieldsResponse, T> g) {
        return obj -> g.apply((DescribeIndexFieldsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudSearchResponse.BuilderImpl
    implements Builder {
        private List<IndexFieldStatus> indexFields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIndexFieldsResponse model) {
            super(model);
            this.indexFields(model.indexFields);
        }

        public final List<IndexFieldStatus.Builder> getIndexFields() {
            List<IndexFieldStatus.Builder> result = IndexFieldStatusListCopier.copyToBuilder(this.indexFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIndexFields(Collection<IndexFieldStatus.BuilderImpl> indexFields) {
            this.indexFields = IndexFieldStatusListCopier.copyFromBuilder(indexFields);
        }

        @Override
        public final Builder indexFields(Collection<IndexFieldStatus> indexFields) {
            this.indexFields = IndexFieldStatusListCopier.copy(indexFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder indexFields(IndexFieldStatus ... indexFields) {
            this.indexFields(Arrays.asList(indexFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder indexFields(Consumer<IndexFieldStatus.Builder> ... indexFields) {
            this.indexFields(Stream.of(indexFields).map(c -> (IndexFieldStatus)((IndexFieldStatus.Builder)IndexFieldStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeIndexFieldsResponse build() {
            return new DescribeIndexFieldsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudSearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeIndexFieldsResponse> {
        public Builder indexFields(Collection<IndexFieldStatus> var1);

        public Builder indexFields(IndexFieldStatus ... var1);

        public Builder indexFields(Consumer<IndexFieldStatus.Builder> ... var1);
    }
}

