/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudsearch.CloudSearchClient;
import software.amazon.awssdk.services.cloudsearch.CloudSearchClientBuilder;
import software.amazon.awssdk.services.cloudsearch.CloudSearchServiceClientConfiguration;
import software.amazon.awssdk.services.cloudsearch.DefaultCloudSearchBaseClientBuilder;
import software.amazon.awssdk.services.cloudsearch.DefaultCloudSearchClient;
import software.amazon.awssdk.services.cloudsearch.endpoints.CloudSearchEndpointProvider;

@SdkInternalApi
final class DefaultCloudSearchClientBuilder
extends DefaultCloudSearchBaseClientBuilder<CloudSearchClientBuilder, CloudSearchClient>
implements CloudSearchClientBuilder {
    DefaultCloudSearchClientBuilder() {
    }

    @Override
    public DefaultCloudSearchClientBuilder endpointProvider(CloudSearchEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CloudSearchClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultCloudSearchClientBuilder.validateClientOptions(clientConfiguration);
        CloudSearchServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultCloudSearchClient client = new DefaultCloudSearchClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private CloudSearchServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return CloudSearchServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

