/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The status of domain configuration option.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OptionStatus implements SdkPojo, Serializable, ToCopyableBuilder<OptionStatus.Builder, OptionStatus> {
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationDate").getter(getter(OptionStatus::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<Instant> UPDATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdateDate").getter(getter(OptionStatus::updateDate)).setter(setter(Builder::updateDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateDate").build()).build();

    private static final SdkField<Integer> UPDATE_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("UpdateVersion").getter(getter(OptionStatus::updateVersion)).setter(setter(Builder::updateVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateVersion").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(OptionStatus::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<Boolean> PENDING_DELETION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PendingDeletion").getter(getter(OptionStatus::pendingDeletion)).setter(setter(Builder::pendingDeletion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingDeletion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_DATE_FIELD,
            UPDATE_DATE_FIELD, UPDATE_VERSION_FIELD, STATE_FIELD, PENDING_DELETION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant creationDate;

    private final Instant updateDate;

    private final Integer updateVersion;

    private final String state;

    private final Boolean pendingDeletion;

    private OptionStatus(BuilderImpl builder) {
        this.creationDate = builder.creationDate;
        this.updateDate = builder.updateDate;
        this.updateVersion = builder.updateVersion;
        this.state = builder.state;
        this.pendingDeletion = builder.pendingDeletion;
    }

    /**
     * <p>
     * A timestamp for when this option was created.
     * </p>
     * 
     * @return A timestamp for when this option was created.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * A timestamp for when this option was last updated.
     * </p>
     * 
     * @return A timestamp for when this option was last updated.
     */
    public final Instant updateDate() {
        return updateDate;
    }

    /**
     * <p>
     * A unique integer that indicates when this option was last updated.
     * </p>
     * 
     * @return A unique integer that indicates when this option was last updated.
     */
    public final Integer updateVersion() {
        return updateVersion;
    }

    /**
     * <p>
     * The state of processing a change to an option. Possible values:
     * </p>
     * <ul>
     * <li><code>RequiresIndexDocuments</code>: the option's latest value will not be deployed until
     * <a>IndexDocuments</a> has been called and indexing is complete.</li>
     * <li><code>Processing</code>: the option's latest value is in the process of being activated.</li>
     * <li><code>Active</code>: the option's latest value is completely deployed.</li>
     * <li><code>FailedToValidate</code>: the option value is not compatible with the domain's data and cannot be used
     * to index the data. You must either modify the option value or update or remove the incompatible documents.</li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link OptionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of processing a change to an option. Possible values:</p>
     *         <ul>
     *         <li><code>RequiresIndexDocuments</code>: the option's latest value will not be deployed until
     *         <a>IndexDocuments</a> has been called and indexing is complete.</li>
     *         <li><code>Processing</code>: the option's latest value is in the process of being activated.</li>
     *         <li><code>Active</code>: the option's latest value is completely deployed.</li>
     *         <li><code>FailedToValidate</code>: the option value is not compatible with the domain's data and cannot
     *         be used to index the data. You must either modify the option value or update or remove the incompatible
     *         documents.</li>
     * @see OptionState
     */
    public final OptionState state() {
        return OptionState.fromValue(state);
    }

    /**
     * <p>
     * The state of processing a change to an option. Possible values:
     * </p>
     * <ul>
     * <li><code>RequiresIndexDocuments</code>: the option's latest value will not be deployed until
     * <a>IndexDocuments</a> has been called and indexing is complete.</li>
     * <li><code>Processing</code>: the option's latest value is in the process of being activated.</li>
     * <li><code>Active</code>: the option's latest value is completely deployed.</li>
     * <li><code>FailedToValidate</code>: the option value is not compatible with the domain's data and cannot be used
     * to index the data. You must either modify the option value or update or remove the incompatible documents.</li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link OptionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of processing a change to an option. Possible values:</p>
     *         <ul>
     *         <li><code>RequiresIndexDocuments</code>: the option's latest value will not be deployed until
     *         <a>IndexDocuments</a> has been called and indexing is complete.</li>
     *         <li><code>Processing</code>: the option's latest value is in the process of being activated.</li>
     *         <li><code>Active</code>: the option's latest value is completely deployed.</li>
     *         <li><code>FailedToValidate</code>: the option value is not compatible with the domain's data and cannot
     *         be used to index the data. You must either modify the option value or update or remove the incompatible
     *         documents.</li>
     * @see OptionState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * Indicates that the option will be deleted once processing is complete.
     * </p>
     * 
     * @return Indicates that the option will be deleted once processing is complete.
     */
    public final Boolean pendingDeletion() {
        return pendingDeletion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(updateDate());
        hashCode = 31 * hashCode + Objects.hashCode(updateVersion());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(pendingDeletion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptionStatus)) {
            return false;
        }
        OptionStatus other = (OptionStatus) obj;
        return Objects.equals(creationDate(), other.creationDate()) && Objects.equals(updateDate(), other.updateDate())
                && Objects.equals(updateVersion(), other.updateVersion())
                && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(pendingDeletion(), other.pendingDeletion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OptionStatus").add("CreationDate", creationDate()).add("UpdateDate", updateDate())
                .add("UpdateVersion", updateVersion()).add("State", stateAsString()).add("PendingDeletion", pendingDeletion())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "UpdateDate":
            return Optional.ofNullable(clazz.cast(updateDate()));
        case "UpdateVersion":
            return Optional.ofNullable(clazz.cast(updateVersion()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "PendingDeletion":
            return Optional.ofNullable(clazz.cast(pendingDeletion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OptionStatus, T> g) {
        return obj -> g.apply((OptionStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OptionStatus> {
        /**
         * <p>
         * A timestamp for when this option was created.
         * </p>
         * 
         * @param creationDate
         *        A timestamp for when this option was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * A timestamp for when this option was last updated.
         * </p>
         * 
         * @param updateDate
         *        A timestamp for when this option was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateDate(Instant updateDate);

        /**
         * <p>
         * A unique integer that indicates when this option was last updated.
         * </p>
         * 
         * @param updateVersion
         *        A unique integer that indicates when this option was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateVersion(Integer updateVersion);

        /**
         * <p>
         * The state of processing a change to an option. Possible values:
         * </p>
         * <ul>
         * <li><code>RequiresIndexDocuments</code>: the option's latest value will not be deployed until
         * <a>IndexDocuments</a> has been called and indexing is complete.</li>
         * <li><code>Processing</code>: the option's latest value is in the process of being activated.</li>
         * <li><code>Active</code>: the option's latest value is completely deployed.</li>
         * <li><code>FailedToValidate</code>: the option value is not compatible with the domain's data and cannot be
         * used to index the data. You must either modify the option value or update or remove the incompatible
         * documents.</li>
         * </ul>
         * 
         * @param state
         *        The state of processing a change to an option. Possible values:</p>
         *        <ul>
         *        <li><code>RequiresIndexDocuments</code>: the option's latest value will not be deployed until
         *        <a>IndexDocuments</a> has been called and indexing is complete.</li>
         *        <li><code>Processing</code>: the option's latest value is in the process of being activated.</li>
         *        <li><code>Active</code>: the option's latest value is completely deployed.</li>
         *        <li><code>FailedToValidate</code>: the option value is not compatible with the domain's data and
         *        cannot be used to index the data. You must either modify the option value or update or remove the
         *        incompatible documents.</li>
         * @see OptionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OptionState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of processing a change to an option. Possible values:
         * </p>
         * <ul>
         * <li><code>RequiresIndexDocuments</code>: the option's latest value will not be deployed until
         * <a>IndexDocuments</a> has been called and indexing is complete.</li>
         * <li><code>Processing</code>: the option's latest value is in the process of being activated.</li>
         * <li><code>Active</code>: the option's latest value is completely deployed.</li>
         * <li><code>FailedToValidate</code>: the option value is not compatible with the domain's data and cannot be
         * used to index the data. You must either modify the option value or update or remove the incompatible
         * documents.</li>
         * </ul>
         * 
         * @param state
         *        The state of processing a change to an option. Possible values:</p>
         *        <ul>
         *        <li><code>RequiresIndexDocuments</code>: the option's latest value will not be deployed until
         *        <a>IndexDocuments</a> has been called and indexing is complete.</li>
         *        <li><code>Processing</code>: the option's latest value is in the process of being activated.</li>
         *        <li><code>Active</code>: the option's latest value is completely deployed.</li>
         *        <li><code>FailedToValidate</code>: the option value is not compatible with the domain's data and
         *        cannot be used to index the data. You must either modify the option value or update or remove the
         *        incompatible documents.</li>
         * @see OptionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OptionState
         */
        Builder state(OptionState state);

        /**
         * <p>
         * Indicates that the option will be deleted once processing is complete.
         * </p>
         * 
         * @param pendingDeletion
         *        Indicates that the option will be deleted once processing is complete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingDeletion(Boolean pendingDeletion);
    }

    static final class BuilderImpl implements Builder {
        private Instant creationDate;

        private Instant updateDate;

        private Integer updateVersion;

        private String state;

        private Boolean pendingDeletion;

        private BuilderImpl() {
        }

        private BuilderImpl(OptionStatus model) {
            creationDate(model.creationDate);
            updateDate(model.updateDate);
            updateVersion(model.updateVersion);
            state(model.state);
            pendingDeletion(model.pendingDeletion);
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getUpdateDate() {
            return updateDate;
        }

        @Override
        public final Builder updateDate(Instant updateDate) {
            this.updateDate = updateDate;
            return this;
        }

        public final void setUpdateDate(Instant updateDate) {
            this.updateDate = updateDate;
        }

        public final Integer getUpdateVersion() {
            return updateVersion;
        }

        @Override
        public final Builder updateVersion(Integer updateVersion) {
            this.updateVersion = updateVersion;
            return this;
        }

        public final void setUpdateVersion(Integer updateVersion) {
            this.updateVersion = updateVersion;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(OptionState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Boolean getPendingDeletion() {
            return pendingDeletion;
        }

        @Override
        public final Builder pendingDeletion(Boolean pendingDeletion) {
            this.pendingDeletion = pendingDeletion;
            return this;
        }

        public final void setPendingDeletion(Boolean pendingDeletion) {
            this.pendingDeletion = pendingDeletion;
        }

        @Override
        public OptionStatus build() {
            return new OptionStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
