/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearch.model;

import static java.util.stream.Collectors.toSet;

import java.util.Set;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

/**
 * <p>
 * The instance type (such as <code>search.m1.small</code>) on which an index partition is hosted.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public enum PartitionInstanceType {
    SEARCH_M1_SMALL("search.m1.small"),

    SEARCH_M1_LARGE("search.m1.large"),

    SEARCH_M2_XLARGE("search.m2.xlarge"),

    SEARCH_M2_2_XLARGE("search.m2.2xlarge"),

    SEARCH_M3_MEDIUM("search.m3.medium"),

    SEARCH_M3_LARGE("search.m3.large"),

    SEARCH_M3_XLARGE("search.m3.xlarge"),

    SEARCH_M3_2_XLARGE("search.m3.2xlarge"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private PartitionInstanceType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return PartitionInstanceType corresponding to the value
     */
    public static PartitionInstanceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(PartitionInstanceType.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link PartitionInstanceType}s
     */
    public static Set<PartitionInstanceType> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(toSet());
    }
}
