/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of a <code>UpdateScalingParameters</code> request. Contains the status of the newly-configured scaling
 * parameters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateScalingParametersResponse extends CloudSearchResponse implements
        ToCopyableBuilder<UpdateScalingParametersResponse.Builder, UpdateScalingParametersResponse> {
    private static final SdkField<ScalingParametersStatus> SCALING_PARAMETERS_FIELD = SdkField
            .<ScalingParametersStatus> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateScalingParametersResponse::scalingParameters)).setter(setter(Builder::scalingParameters))
            .constructor(ScalingParametersStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingParameters").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALING_PARAMETERS_FIELD));

    private final ScalingParametersStatus scalingParameters;

    private UpdateScalingParametersResponse(BuilderImpl builder) {
        super(builder);
        this.scalingParameters = builder.scalingParameters;
    }

    /**
     * Returns the value of the ScalingParameters property for this object.
     * 
     * @return The value of the ScalingParameters property for this object.
     */
    public ScalingParametersStatus scalingParameters() {
        return scalingParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(scalingParameters());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateScalingParametersResponse)) {
            return false;
        }
        UpdateScalingParametersResponse other = (UpdateScalingParametersResponse) obj;
        return Objects.equals(scalingParameters(), other.scalingParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateScalingParametersResponse").add("ScalingParameters", scalingParameters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScalingParameters":
            return Optional.ofNullable(clazz.cast(scalingParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateScalingParametersResponse, T> g) {
        return obj -> g.apply((UpdateScalingParametersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudSearchResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateScalingParametersResponse> {
        /**
         * Sets the value of the ScalingParameters property for this object.
         *
         * @param scalingParameters
         *        The new value for the ScalingParameters property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingParameters(ScalingParametersStatus scalingParameters);

        /**
         * Sets the value of the ScalingParameters property for this object.
         *
         * This is a convenience that creates an instance of the {@link ScalingParametersStatus.Builder} avoiding the
         * need to create one manually via {@link ScalingParametersStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link ScalingParametersStatus.Builder#build()} is called immediately
         * and its result is passed to {@link #scalingParameters(ScalingParametersStatus)}.
         * 
         * @param scalingParameters
         *        a consumer that will call methods on {@link ScalingParametersStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scalingParameters(ScalingParametersStatus)
         */
        default Builder scalingParameters(Consumer<ScalingParametersStatus.Builder> scalingParameters) {
            return scalingParameters(ScalingParametersStatus.builder().applyMutation(scalingParameters).build());
        }
    }

    static final class BuilderImpl extends CloudSearchResponse.BuilderImpl implements Builder {
        private ScalingParametersStatus scalingParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateScalingParametersResponse model) {
            super(model);
            scalingParameters(model.scalingParameters);
        }

        public final ScalingParametersStatus.Builder getScalingParameters() {
            return scalingParameters != null ? scalingParameters.toBuilder() : null;
        }

        @Override
        public final Builder scalingParameters(ScalingParametersStatus scalingParameters) {
            this.scalingParameters = scalingParameters;
            return this;
        }

        public final void setScalingParameters(ScalingParametersStatus.BuilderImpl scalingParameters) {
            this.scalingParameters = scalingParameters != null ? scalingParameters.build() : null;
        }

        @Override
        public UpdateScalingParametersResponse build() {
            return new UpdateScalingParametersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
