/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearch.model;

import static java.util.stream.Collectors.toSet;

import java.util.Set;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

/**
 * <p>
 * The state of processing a change to an option. One of:
 * </p>
 * <ul>
 * <li>RequiresIndexDocuments: The option's latest value will not be deployed until <a>IndexDocuments</a> has been
 * called and indexing is complete.</li>
 * <li>Processing: The option's latest value is in the process of being activated.</li>
 * <li>Active: The option's latest value is fully deployed.</li>
 * <li>FailedToValidate: The option value is not compatible with the domain's data and cannot be used to index the data.
 * You must either modify the option value or update or remove the incompatible documents.</li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public enum OptionState {
    REQUIRES_INDEX_DOCUMENTS("RequiresIndexDocuments"),

    PROCESSING("Processing"),

    ACTIVE("Active"),

    FAILED_TO_VALIDATE("FailedToValidate"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private OptionState(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return OptionState corresponding to the value
     */
    public static OptionState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(OptionState.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link OptionState}s
     */
    public static Set<OptionState> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(toSet());
    }
}
