/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for the parameters to the <code><a>DefineIndexField</a></code> operation. Specifies the name of the domain
 * you want to update and the index field configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DefineIndexFieldRequest extends CloudSearchRequest implements
        ToCopyableBuilder<DefineIndexFieldRequest.Builder, DefineIndexFieldRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DefineIndexFieldRequest::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<IndexField> INDEX_FIELD_FIELD = SdkField.<IndexField> builder(MarshallingType.SDK_POJO)
            .getter(getter(DefineIndexFieldRequest::indexField)).setter(setter(Builder::indexField))
            .constructor(IndexField::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexField").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            INDEX_FIELD_FIELD));

    private final String domainName;

    private final IndexField indexField;

    private DefineIndexFieldRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.indexField = builder.indexField;
    }

    /**
     * Returns the value of the DomainName property for this object.
     * 
     * @return The value of the DomainName property for this object.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The index field and field options you want to configure.
     * </p>
     * 
     * @return The index field and field options you want to configure.
     */
    public IndexField indexField() {
        return indexField;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(indexField());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefineIndexFieldRequest)) {
            return false;
        }
        DefineIndexFieldRequest other = (DefineIndexFieldRequest) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(indexField(), other.indexField());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DefineIndexFieldRequest").add("DomainName", domainName()).add("IndexField", indexField())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "IndexField":
            return Optional.ofNullable(clazz.cast(indexField()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DefineIndexFieldRequest, T> g) {
        return obj -> g.apply((DefineIndexFieldRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudSearchRequest.Builder, SdkPojo, CopyableBuilder<Builder, DefineIndexFieldRequest> {
        /**
         * Sets the value of the DomainName property for this object.
         *
         * @param domainName
         *        The new value for the DomainName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The index field and field options you want to configure.
         * </p>
         * 
         * @param indexField
         *        The index field and field options you want to configure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexField(IndexField indexField);

        /**
         * <p>
         * The index field and field options you want to configure.
         * </p>
         * This is a convenience that creates an instance of the {@link IndexField.Builder} avoiding the need to create
         * one manually via {@link IndexField#builder()}.
         *
         * When the {@link Consumer} completes, {@link IndexField.Builder#build()} is called immediately and its result
         * is passed to {@link #indexField(IndexField)}.
         * 
         * @param indexField
         *        a consumer that will call methods on {@link IndexField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #indexField(IndexField)
         */
        default Builder indexField(Consumer<IndexField.Builder> indexField) {
            return indexField(IndexField.builder().applyMutation(indexField).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudSearchRequest.BuilderImpl implements Builder {
        private String domainName;

        private IndexField indexField;

        private BuilderImpl() {
        }

        private BuilderImpl(DefineIndexFieldRequest model) {
            super(model);
            domainName(model.domainName);
            indexField(model.indexField);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final IndexField.Builder getIndexField() {
            return indexField != null ? indexField.toBuilder() : null;
        }

        @Override
        public final Builder indexField(IndexField indexField) {
            this.indexField = indexField;
            return this;
        }

        public final void setIndexField(IndexField.BuilderImpl indexField) {
            this.indexField = indexField != null ? indexField.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DefineIndexFieldRequest build() {
            return new DefineIndexFieldRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
