/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudsearch.model.OptionState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OptionStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OptionStatus> {
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(OptionStatus.getter(OptionStatus::creationDate)).setter(OptionStatus.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<Instant> UPDATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(OptionStatus.getter(OptionStatus::updateDate)).setter(OptionStatus.setter(Builder::updateDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateDate").build()}).build();
    private static final SdkField<Integer> UPDATE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(OptionStatus.getter(OptionStatus::updateVersion)).setter(OptionStatus.setter(Builder::updateVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateVersion").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OptionStatus.getter(OptionStatus::stateAsString)).setter(OptionStatus.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<Boolean> PENDING_DELETION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(OptionStatus.getter(OptionStatus::pendingDeletion)).setter(OptionStatus.setter(Builder::pendingDeletion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingDeletion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_DATE_FIELD, UPDATE_DATE_FIELD, UPDATE_VERSION_FIELD, STATE_FIELD, PENDING_DELETION_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant creationDate;
    private final Instant updateDate;
    private final Integer updateVersion;
    private final String state;
    private final Boolean pendingDeletion;

    private OptionStatus(BuilderImpl builder) {
        this.creationDate = builder.creationDate;
        this.updateDate = builder.updateDate;
        this.updateVersion = builder.updateVersion;
        this.state = builder.state;
        this.pendingDeletion = builder.pendingDeletion;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Instant updateDate() {
        return this.updateDate;
    }

    public Integer updateVersion() {
        return this.updateVersion;
    }

    public OptionState state() {
        return OptionState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public Boolean pendingDeletion() {
        return this.pendingDeletion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingDeletion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptionStatus)) {
            return false;
        }
        OptionStatus other = (OptionStatus)obj;
        return Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.updateDate(), other.updateDate()) && Objects.equals(this.updateVersion(), other.updateVersion()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.pendingDeletion(), other.pendingDeletion());
    }

    public String toString() {
        return ToString.builder((String)"OptionStatus").add("CreationDate", (Object)this.creationDate()).add("UpdateDate", (Object)this.updateDate()).add("UpdateVersion", (Object)this.updateVersion()).add("State", (Object)this.stateAsString()).add("PendingDeletion", (Object)this.pendingDeletion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "UpdateDate": {
                return Optional.ofNullable(clazz.cast(this.updateDate()));
            }
            case "UpdateVersion": {
                return Optional.ofNullable(clazz.cast(this.updateVersion()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "PendingDeletion": {
                return Optional.ofNullable(clazz.cast(this.pendingDeletion()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OptionStatus, T> g) {
        return obj -> g.apply((OptionStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant creationDate;
        private Instant updateDate;
        private Integer updateVersion;
        private String state;
        private Boolean pendingDeletion;

        private BuilderImpl() {
        }

        private BuilderImpl(OptionStatus model) {
            this.creationDate(model.creationDate);
            this.updateDate(model.updateDate);
            this.updateVersion(model.updateVersion);
            this.state(model.state);
            this.pendingDeletion(model.pendingDeletion);
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getUpdateDate() {
            return this.updateDate;
        }

        @Override
        public final Builder updateDate(Instant updateDate) {
            this.updateDate = updateDate;
            return this;
        }

        public final void setUpdateDate(Instant updateDate) {
            this.updateDate = updateDate;
        }

        public final Integer getUpdateVersion() {
            return this.updateVersion;
        }

        @Override
        public final Builder updateVersion(Integer updateVersion) {
            this.updateVersion = updateVersion;
            return this;
        }

        public final void setUpdateVersion(Integer updateVersion) {
            this.updateVersion = updateVersion;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(OptionState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Boolean getPendingDeletion() {
            return this.pendingDeletion;
        }

        @Override
        public final Builder pendingDeletion(Boolean pendingDeletion) {
            this.pendingDeletion = pendingDeletion;
            return this;
        }

        public final void setPendingDeletion(Boolean pendingDeletion) {
            this.pendingDeletion = pendingDeletion;
        }

        public OptionStatus build() {
            return new OptionStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OptionStatus> {
        public Builder creationDate(Instant var1);

        public Builder updateDate(Instant var1);

        public Builder updateVersion(Integer var1);

        public Builder state(String var1);

        public Builder state(OptionState var1);

        public Builder pendingDeletion(Boolean var1);
    }
}

