/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearchdomain.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudsearchdomain.transform.FieldStatsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class FieldStats
implements StructuredPojo,
ToCopyableBuilder<Builder, FieldStats> {
    private final String min;
    private final String max;
    private final Long count;
    private final Long missing;
    private final Double sum;
    private final Double sumOfSquares;
    private final String mean;
    private final Double stddev;

    private FieldStats(BuilderImpl builder) {
        this.min = builder.min;
        this.max = builder.max;
        this.count = builder.count;
        this.missing = builder.missing;
        this.sum = builder.sum;
        this.sumOfSquares = builder.sumOfSquares;
        this.mean = builder.mean;
        this.stddev = builder.stddev;
    }

    public String min() {
        return this.min;
    }

    public String max() {
        return this.max;
    }

    public Long count() {
        return this.count;
    }

    public Long missing() {
        return this.missing;
    }

    public Double sum() {
        return this.sum;
    }

    public Double sumOfSquares() {
        return this.sumOfSquares;
    }

    public String mean() {
        return this.mean;
    }

    public Double stddev() {
        return this.stddev;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.min());
        hashCode = 31 * hashCode + Objects.hashCode(this.max());
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        hashCode = 31 * hashCode + Objects.hashCode(this.missing());
        hashCode = 31 * hashCode + Objects.hashCode(this.sum());
        hashCode = 31 * hashCode + Objects.hashCode(this.sumOfSquares());
        hashCode = 31 * hashCode + Objects.hashCode(this.mean());
        hashCode = 31 * hashCode + Objects.hashCode(this.stddev());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldStats)) {
            return false;
        }
        FieldStats other = (FieldStats)obj;
        return Objects.equals(this.min(), other.min()) && Objects.equals(this.max(), other.max()) && Objects.equals(this.count(), other.count()) && Objects.equals(this.missing(), other.missing()) && Objects.equals(this.sum(), other.sum()) && Objects.equals(this.sumOfSquares(), other.sumOfSquares()) && Objects.equals(this.mean(), other.mean()) && Objects.equals(this.stddev(), other.stddev());
    }

    public String toString() {
        return ToString.builder((String)"FieldStats").add("Min", (Object)this.min()).add("Max", (Object)this.max()).add("Count", (Object)this.count()).add("Missing", (Object)this.missing()).add("Sum", (Object)this.sum()).add("SumOfSquares", (Object)this.sumOfSquares()).add("Mean", (Object)this.mean()).add("Stddev", (Object)this.stddev()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "min": {
                return Optional.of(clazz.cast(this.min()));
            }
            case "max": {
                return Optional.of(clazz.cast(this.max()));
            }
            case "count": {
                return Optional.of(clazz.cast(this.count()));
            }
            case "missing": {
                return Optional.of(clazz.cast(this.missing()));
            }
            case "sum": {
                return Optional.of(clazz.cast(this.sum()));
            }
            case "sumOfSquares": {
                return Optional.of(clazz.cast(this.sumOfSquares()));
            }
            case "mean": {
                return Optional.of(clazz.cast(this.mean()));
            }
            case "stddev": {
                return Optional.of(clazz.cast(this.stddev()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FieldStatsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String min;
        private String max;
        private Long count;
        private Long missing;
        private Double sum;
        private Double sumOfSquares;
        private String mean;
        private Double stddev;

        private BuilderImpl() {
        }

        private BuilderImpl(FieldStats model) {
            this.min(model.min);
            this.max(model.max);
            this.count(model.count);
            this.missing(model.missing);
            this.sum(model.sum);
            this.sumOfSquares(model.sumOfSquares);
            this.mean(model.mean);
            this.stddev(model.stddev);
        }

        public final String getMin() {
            return this.min;
        }

        @Override
        public final Builder min(String min) {
            this.min = min;
            return this;
        }

        public final void setMin(String min) {
            this.min = min;
        }

        public final String getMax() {
            return this.max;
        }

        @Override
        public final Builder max(String max) {
            this.max = max;
            return this;
        }

        public final void setMax(String max) {
            this.max = max;
        }

        public final Long getCount() {
            return this.count;
        }

        @Override
        public final Builder count(Long count) {
            this.count = count;
            return this;
        }

        public final void setCount(Long count) {
            this.count = count;
        }

        public final Long getMissing() {
            return this.missing;
        }

        @Override
        public final Builder missing(Long missing) {
            this.missing = missing;
            return this;
        }

        public final void setMissing(Long missing) {
            this.missing = missing;
        }

        public final Double getSum() {
            return this.sum;
        }

        @Override
        public final Builder sum(Double sum) {
            this.sum = sum;
            return this;
        }

        public final void setSum(Double sum) {
            this.sum = sum;
        }

        public final Double getSumOfSquares() {
            return this.sumOfSquares;
        }

        @Override
        public final Builder sumOfSquares(Double sumOfSquares) {
            this.sumOfSquares = sumOfSquares;
            return this;
        }

        public final void setSumOfSquares(Double sumOfSquares) {
            this.sumOfSquares = sumOfSquares;
        }

        public final String getMean() {
            return this.mean;
        }

        @Override
        public final Builder mean(String mean) {
            this.mean = mean;
            return this;
        }

        public final void setMean(String mean) {
            this.mean = mean;
        }

        public final Double getStddev() {
            return this.stddev;
        }

        @Override
        public final Builder stddev(Double stddev) {
            this.stddev = stddev;
            return this;
        }

        public final void setStddev(Double stddev) {
            this.stddev = stddev;
        }

        public FieldStats build() {
            return new FieldStats(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FieldStats> {
        public Builder min(String var1);

        public Builder max(String var1);

        public Builder count(Long var1);

        public Builder missing(Long var1);

        public Builder sum(Double var1);

        public Builder sumOfSquares(Double var1);

        public Builder mean(String var1);

        public Builder stddev(Double var1);
    }
}

