/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearchdomain.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.cloudsearchdomain.model.CloudSearchDomainRequest;
import software.amazon.awssdk.services.cloudsearchdomain.model.ContentType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UploadDocumentsRequest
extends CloudSearchDomainRequest
implements ToCopyableBuilder<Builder, UploadDocumentsRequest> {
    private final String contentType;
    private final Long contentLength;

    private UploadDocumentsRequest(BuilderImpl builder) {
        super(builder);
        this.contentType = builder.contentType;
        this.contentLength = builder.contentLength;
    }

    public ContentType contentType() {
        return ContentType.fromValue(this.contentType);
    }

    public String contentTypeString() {
        return this.contentType;
    }

    public Long contentLength() {
        return this.contentLength;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.contentTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentLength());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadDocumentsRequest)) {
            return false;
        }
        UploadDocumentsRequest other = (UploadDocumentsRequest)((Object)obj);
        return Objects.equals(this.contentTypeString(), other.contentTypeString()) && Objects.equals(this.contentLength(), other.contentLength());
    }

    public String toString() {
        return ToString.builder((String)"UploadDocumentsRequest").add("ContentType", (Object)this.contentTypeString()).add("ContentLength", (Object)this.contentLength()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "contentType": {
                return Optional.of(clazz.cast(this.contentTypeString()));
            }
            case "ContentLength": {
                return Optional.of(clazz.cast(this.contentLength()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudSearchDomainRequest.BuilderImpl
    implements Builder {
        private String contentType;
        private Long contentLength;

        private BuilderImpl() {
        }

        private BuilderImpl(UploadDocumentsRequest model) {
            this.contentType(model.contentType);
            this.contentLength(model.contentLength);
        }

        public final String getContentType() {
            return this.contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public final Builder contentType(ContentType contentType) {
            this.contentType(contentType.toString());
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final Long getContentLength() {
            return this.contentLength;
        }

        @Override
        public final Builder contentLength(Long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        public final void setContentLength(Long contentLength) {
            this.contentLength = contentLength;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UploadDocumentsRequest build() {
            return new UploadDocumentsRequest(this);
        }
    }

    public static interface Builder
    extends CloudSearchDomainRequest.Builder,
    CopyableBuilder<Builder, UploadDocumentsRequest> {
        public Builder contentType(String var1);

        public Builder contentType(ContentType var1);

        public Builder contentLength(Long var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

