/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.cloudsearch.model.DescribeDomainsRequest;

public class DescribeDomainsRequestMarshaller
implements Marshaller<Request<DescribeDomainsRequest>, DescribeDomainsRequest> {
    public Request<DescribeDomainsRequest> marshall(DescribeDomainsRequest describeDomainsRequest) {
        if (describeDomainsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)describeDomainsRequest, "AmazonCloudSearchv2");
        request.addParameter("Action", "DescribeDomains");
        request.addParameter("Version", "2013-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> domainNamesList = describeDomainsRequest.domainNames();
        if (domainNamesList != null) {
            if (!domainNamesList.isEmpty()) {
                int domainNamesListIndex = 1;
                for (String domainNamesListValue : domainNamesList) {
                    if (domainNamesListValue != null) {
                        request.addParameter("DomainNames.member." + domainNamesListIndex, StringUtils.fromString((String)domainNamesListValue));
                    }
                    ++domainNamesListIndex;
                }
            } else {
                request.addParameter("DomainNames", "");
            }
        }
        return request;
    }
}

