/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.cloudsearch.model.DescribeAnalysisSchemesRequest;

public class DescribeAnalysisSchemesRequestMarshaller
implements Marshaller<Request<DescribeAnalysisSchemesRequest>, DescribeAnalysisSchemesRequest> {
    public Request<DescribeAnalysisSchemesRequest> marshall(DescribeAnalysisSchemesRequest describeAnalysisSchemesRequest) {
        List<String> analysisSchemeNamesList;
        if (describeAnalysisSchemesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)describeAnalysisSchemesRequest, "AmazonCloudSearchv2");
        request.addParameter("Action", "DescribeAnalysisSchemes");
        request.addParameter("Version", "2013-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeAnalysisSchemesRequest.domainName() != null) {
            request.addParameter("DomainName", StringUtils.fromString((String)describeAnalysisSchemesRequest.domainName()));
        }
        if ((analysisSchemeNamesList = describeAnalysisSchemesRequest.analysisSchemeNames()) != null) {
            if (!analysisSchemeNamesList.isEmpty()) {
                int analysisSchemeNamesListIndex = 1;
                for (String analysisSchemeNamesListValue : analysisSchemeNamesList) {
                    if (analysisSchemeNamesListValue != null) {
                        request.addParameter("AnalysisSchemeNames.member." + analysisSchemeNamesListIndex, StringUtils.fromString((String)analysisSchemeNamesListValue));
                    }
                    ++analysisSchemeNamesListIndex;
                }
            } else {
                request.addParameter("AnalysisSchemeNames", "");
            }
        }
        if (describeAnalysisSchemesRequest.deployed() != null) {
            request.addParameter("Deployed", StringUtils.fromBoolean((Boolean)describeAnalysisSchemesRequest.deployed()));
        }
        return request;
    }
}

