/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearchdomain.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudsearchdomain.model.FieldStats;

public class FieldStatsUnmarshaller
implements Unmarshaller<FieldStats, JsonUnmarshallerContext> {
    private static final FieldStatsUnmarshaller INSTANCE = new FieldStatsUnmarshaller();

    public FieldStats unmarshall(JsonUnmarshallerContext context) throws Exception {
        FieldStats.Builder fieldStatsBuilder = FieldStats.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("min", targetDepth)) {
                    context.nextToken();
                    fieldStatsBuilder.min((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("max", targetDepth)) {
                    context.nextToken();
                    fieldStatsBuilder.max((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("count", targetDepth)) {
                    context.nextToken();
                    fieldStatsBuilder.count((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("missing", targetDepth)) {
                    context.nextToken();
                    fieldStatsBuilder.missing((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("sum", targetDepth)) {
                    context.nextToken();
                    fieldStatsBuilder.sum((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
                if (context.testExpression("sumOfSquares", targetDepth)) {
                    context.nextToken();
                    fieldStatsBuilder.sumOfSquares((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
                if (context.testExpression("mean", targetDepth)) {
                    context.nextToken();
                    fieldStatsBuilder.mean((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("stddev", targetDepth)) {
                    context.nextToken();
                    fieldStatsBuilder.stddev((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (FieldStats)fieldStatsBuilder.build();
    }

    public static FieldStatsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

