/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearchdomain.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.cloudsearchdomain.model.CloudSearchDomainResponse;
import software.amazon.awssdk.services.cloudsearchdomain.model.DocumentServiceWarning;
import software.amazon.awssdk.services.cloudsearchdomain.model.DocumentServiceWarningsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UploadDocumentsResponse
extends CloudSearchDomainResponse
implements ToCopyableBuilder<Builder, UploadDocumentsResponse> {
    private final String status;
    private final Long adds;
    private final Long deletes;
    private final List<DocumentServiceWarning> warnings;

    private UploadDocumentsResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.adds = builder.adds;
        this.deletes = builder.deletes;
        this.warnings = builder.warnings;
    }

    public String status() {
        return this.status;
    }

    public Long adds() {
        return this.adds;
    }

    public Long deletes() {
        return this.deletes;
    }

    public List<DocumentServiceWarning> warnings() {
        return this.warnings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.adds());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletes());
        hashCode = 31 * hashCode + Objects.hashCode(this.warnings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadDocumentsResponse)) {
            return false;
        }
        UploadDocumentsResponse other = (UploadDocumentsResponse)((Object)obj);
        return Objects.equals(this.status(), other.status()) && Objects.equals(this.adds(), other.adds()) && Objects.equals(this.deletes(), other.deletes()) && Objects.equals(this.warnings(), other.warnings());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.adds() != null) {
            sb.append("Adds: ").append(this.adds()).append(",");
        }
        if (this.deletes() != null) {
            sb.append("Deletes: ").append(this.deletes()).append(",");
        }
        if (this.warnings() != null) {
            sb.append("Warnings: ").append(this.warnings()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.of(clazz.cast(this.status()));
            }
            case "adds": {
                return Optional.of(clazz.cast(this.adds()));
            }
            case "deletes": {
                return Optional.of(clazz.cast(this.deletes()));
            }
            case "warnings": {
                return Optional.of(clazz.cast(this.warnings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudSearchDomainResponse.BuilderImpl
    implements Builder {
        private String status;
        private Long adds;
        private Long deletes;
        private List<DocumentServiceWarning> warnings;

        private BuilderImpl() {
        }

        private BuilderImpl(UploadDocumentsResponse model) {
            this.status(model.status);
            this.adds(model.adds);
            this.deletes(model.deletes);
            this.warnings(model.warnings);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Long getAdds() {
            return this.adds;
        }

        @Override
        public final Builder adds(Long adds) {
            this.adds = adds;
            return this;
        }

        public final void setAdds(Long adds) {
            this.adds = adds;
        }

        public final Long getDeletes() {
            return this.deletes;
        }

        @Override
        public final Builder deletes(Long deletes) {
            this.deletes = deletes;
            return this;
        }

        public final void setDeletes(Long deletes) {
            this.deletes = deletes;
        }

        public final Collection<DocumentServiceWarning.Builder> getWarnings() {
            return this.warnings != null ? (Collection)this.warnings.stream().map(DocumentServiceWarning::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder warnings(Collection<DocumentServiceWarning> warnings) {
            this.warnings = DocumentServiceWarningsCopier.copy(warnings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(DocumentServiceWarning ... warnings) {
            this.warnings(Arrays.asList(warnings));
            return this;
        }

        public final void setWarnings(Collection<DocumentServiceWarning.BuilderImpl> warnings) {
            this.warnings = DocumentServiceWarningsCopier.copyFromBuilder(warnings);
        }

        @Override
        public UploadDocumentsResponse build() {
            return new UploadDocumentsResponse(this);
        }
    }

    public static interface Builder
    extends CloudSearchDomainResponse.Builder,
    CopyableBuilder<Builder, UploadDocumentsResponse> {
        public Builder status(String var1);

        public Builder adds(Long var1);

        public Builder deletes(Long var1);

        public Builder warnings(Collection<DocumentServiceWarning> var1);

        public Builder warnings(DocumentServiceWarning ... var1);
    }
}

