/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearchdomain.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.cloudsearchdomain.model.CloudSearchDomainRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SuggestRequest
extends CloudSearchDomainRequest
implements ToCopyableBuilder<Builder, SuggestRequest> {
    private final String query;
    private final String suggester;
    private final Long size;

    private SuggestRequest(BuilderImpl builder) {
        super(builder);
        this.query = builder.query;
        this.suggester = builder.suggester;
        this.size = builder.size;
    }

    public String query() {
        return this.query;
    }

    public String suggester() {
        return this.suggester;
    }

    public Long size() {
        return this.size;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.query());
        hashCode = 31 * hashCode + Objects.hashCode(this.suggester());
        hashCode = 31 * hashCode + Objects.hashCode(this.size());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuggestRequest)) {
            return false;
        }
        SuggestRequest other = (SuggestRequest)((Object)obj);
        return Objects.equals(this.query(), other.query()) && Objects.equals(this.suggester(), other.suggester()) && Objects.equals(this.size(), other.size());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.query() != null) {
            sb.append("Query: ").append(this.query()).append(",");
        }
        if (this.suggester() != null) {
            sb.append("Suggester: ").append(this.suggester()).append(",");
        }
        if (this.size() != null) {
            sb.append("Size: ").append(this.size()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "query": {
                return Optional.of(clazz.cast(this.query()));
            }
            case "suggester": {
                return Optional.of(clazz.cast(this.suggester()));
            }
            case "size": {
                return Optional.of(clazz.cast(this.size()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudSearchDomainRequest.BuilderImpl
    implements Builder {
        private String query;
        private String suggester;
        private Long size;

        private BuilderImpl() {
        }

        private BuilderImpl(SuggestRequest model) {
            this.query(model.query);
            this.suggester(model.suggester);
            this.size(model.size);
        }

        public final String getQuery() {
            return this.query;
        }

        @Override
        public final Builder query(String query) {
            this.query = query;
            return this;
        }

        public final void setQuery(String query) {
            this.query = query;
        }

        public final String getSuggester() {
            return this.suggester;
        }

        @Override
        public final Builder suggester(String suggester) {
            this.suggester = suggester;
            return this;
        }

        public final void setSuggester(String suggester) {
            this.suggester = suggester;
        }

        public final Long getSize() {
            return this.size;
        }

        @Override
        public final Builder size(Long size) {
            this.size = size;
            return this;
        }

        public final void setSize(Long size) {
            this.size = size;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public SuggestRequest build() {
            return new SuggestRequest(this);
        }
    }

    public static interface Builder
    extends CloudSearchDomainRequest.Builder,
    CopyableBuilder<Builder, SuggestRequest> {
        public Builder query(String var1);

        public Builder suggester(String var1);

        public Builder size(Long var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

