/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.cloudsearch.model.Expression;
import software.amazon.awssdk.services.cloudsearch.model.OptionStatus;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ExpressionStatus
implements ToCopyableBuilder<Builder, ExpressionStatus> {
    private final Expression options;
    private final OptionStatus status;

    private ExpressionStatus(BuilderImpl builder) {
        this.options = builder.options;
        this.status = builder.status;
    }

    public Expression options() {
        return this.options;
    }

    public OptionStatus status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.options());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExpressionStatus)) {
            return false;
        }
        ExpressionStatus other = (ExpressionStatus)obj;
        return Objects.equals(this.options(), other.options()) && Objects.equals(this.status(), other.status());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.options() != null) {
            sb.append("Options: ").append(this.options()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Options": {
                return Optional.of(clazz.cast(this.options()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Expression options;
        private OptionStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(ExpressionStatus model) {
            this.options(model.options);
            this.status(model.status);
        }

        public final Expression.Builder getOptions() {
            return this.options != null ? this.options.toBuilder() : null;
        }

        @Override
        public final Builder options(Expression options) {
            this.options = options;
            return this;
        }

        public final void setOptions(Expression.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        public final OptionStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        @Override
        public final Builder status(OptionStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(OptionStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public ExpressionStatus build() {
            return new ExpressionStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ExpressionStatus> {
        public Builder options(Expression var1);

        default public Builder options(Consumer<Expression.Builder> options) {
            return this.options((Expression)((Expression.Builder)Expression.builder().apply(options)).build());
        }

        public Builder status(OptionStatus var1);

        default public Builder status(Consumer<OptionStatus.Builder> status) {
            return this.status((OptionStatus)((OptionStatus.Builder)OptionStatus.builder().apply(status)).build());
        }
    }
}

