/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteIndexFieldRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteIndexFieldRequest> {
    private final String domainName;
    private final String indexFieldName;

    private DeleteIndexFieldRequest(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.indexFieldName = builder.indexFieldName;
    }

    public String domainName() {
        return this.domainName;
    }

    public String indexFieldName() {
        return this.indexFieldName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexFieldName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteIndexFieldRequest)) {
            return false;
        }
        DeleteIndexFieldRequest other = (DeleteIndexFieldRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.indexFieldName(), other.indexFieldName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.domainName() != null) {
            sb.append("DomainName: ").append(this.domainName()).append(",");
        }
        if (this.indexFieldName() != null) {
            sb.append("IndexFieldName: ").append(this.indexFieldName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.of(clazz.cast(this.domainName()));
            }
            case "IndexFieldName": {
                return Optional.of(clazz.cast(this.indexFieldName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String domainName;
        private String indexFieldName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteIndexFieldRequest model) {
            this.domainName(model.domainName);
            this.indexFieldName(model.indexFieldName);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getIndexFieldName() {
            return this.indexFieldName;
        }

        @Override
        public final Builder indexFieldName(String indexFieldName) {
            this.indexFieldName = indexFieldName;
            return this;
        }

        public final void setIndexFieldName(String indexFieldName) {
            this.indexFieldName = indexFieldName;
        }

        public DeleteIndexFieldRequest build() {
            return new DeleteIndexFieldRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteIndexFieldRequest> {
        public Builder domainName(String var1);

        public Builder indexFieldName(String var1);
    }
}

