/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.cloudsearch.model.DateArrayOptions;
import software.amazon.awssdk.services.cloudsearch.model.DateOptions;
import software.amazon.awssdk.services.cloudsearch.model.DefineIndexFieldRequest;
import software.amazon.awssdk.services.cloudsearch.model.DoubleArrayOptions;
import software.amazon.awssdk.services.cloudsearch.model.DoubleOptions;
import software.amazon.awssdk.services.cloudsearch.model.IndexField;
import software.amazon.awssdk.services.cloudsearch.model.IntArrayOptions;
import software.amazon.awssdk.services.cloudsearch.model.IntOptions;
import software.amazon.awssdk.services.cloudsearch.model.LatLonOptions;
import software.amazon.awssdk.services.cloudsearch.model.LiteralArrayOptions;
import software.amazon.awssdk.services.cloudsearch.model.LiteralOptions;
import software.amazon.awssdk.services.cloudsearch.model.TextArrayOptions;
import software.amazon.awssdk.services.cloudsearch.model.TextOptions;

public class DefineIndexFieldRequestMarshaller
implements Marshaller<Request<DefineIndexFieldRequest>, DefineIndexFieldRequest> {
    public Request<DefineIndexFieldRequest> marshall(DefineIndexFieldRequest defineIndexFieldRequest) {
        IndexField indexField;
        if (defineIndexFieldRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)defineIndexFieldRequest, "AmazonCloudSearchv2");
        request.addParameter("Action", "DefineIndexField");
        request.addParameter("Version", "2013-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (defineIndexFieldRequest.domainName() != null) {
            request.addParameter("DomainName", StringUtils.fromString((String)defineIndexFieldRequest.domainName()));
        }
        if ((indexField = defineIndexFieldRequest.indexField()) != null) {
            DateArrayOptions dateArrayOptions;
            TextArrayOptions textArrayOptions;
            LiteralArrayOptions literalArrayOptions;
            DoubleArrayOptions doubleArrayOptions;
            IntArrayOptions intArrayOptions;
            LatLonOptions latLonOptions;
            DateOptions dateOptions;
            TextOptions textOptions;
            LiteralOptions literalOptions;
            DoubleOptions doubleOptions;
            IntOptions intOptions;
            if (indexField.indexFieldName() != null) {
                request.addParameter("IndexField.IndexFieldName", StringUtils.fromString((String)indexField.indexFieldName()));
            }
            if (indexField.indexFieldTypeString() != null) {
                request.addParameter("IndexField.IndexFieldType", StringUtils.fromString((String)indexField.indexFieldTypeString()));
            }
            if ((intOptions = indexField.intOptions()) != null) {
                if (intOptions.defaultValue() != null) {
                    request.addParameter("IndexField.IntOptions.DefaultValue", StringUtils.fromLong((Long)intOptions.defaultValue()));
                }
                if (intOptions.sourceField() != null) {
                    request.addParameter("IndexField.IntOptions.SourceField", StringUtils.fromString((String)intOptions.sourceField()));
                }
                if (intOptions.facetEnabled() != null) {
                    request.addParameter("IndexField.IntOptions.FacetEnabled", StringUtils.fromBoolean((Boolean)intOptions.facetEnabled()));
                }
                if (intOptions.searchEnabled() != null) {
                    request.addParameter("IndexField.IntOptions.SearchEnabled", StringUtils.fromBoolean((Boolean)intOptions.searchEnabled()));
                }
                if (intOptions.returnEnabled() != null) {
                    request.addParameter("IndexField.IntOptions.ReturnEnabled", StringUtils.fromBoolean((Boolean)intOptions.returnEnabled()));
                }
                if (intOptions.sortEnabled() != null) {
                    request.addParameter("IndexField.IntOptions.SortEnabled", StringUtils.fromBoolean((Boolean)intOptions.sortEnabled()));
                }
            }
            if ((doubleOptions = indexField.doubleOptions()) != null) {
                if (doubleOptions.defaultValue() != null) {
                    request.addParameter("IndexField.DoubleOptions.DefaultValue", StringUtils.fromDouble((Double)doubleOptions.defaultValue()));
                }
                if (doubleOptions.sourceField() != null) {
                    request.addParameter("IndexField.DoubleOptions.SourceField", StringUtils.fromString((String)doubleOptions.sourceField()));
                }
                if (doubleOptions.facetEnabled() != null) {
                    request.addParameter("IndexField.DoubleOptions.FacetEnabled", StringUtils.fromBoolean((Boolean)doubleOptions.facetEnabled()));
                }
                if (doubleOptions.searchEnabled() != null) {
                    request.addParameter("IndexField.DoubleOptions.SearchEnabled", StringUtils.fromBoolean((Boolean)doubleOptions.searchEnabled()));
                }
                if (doubleOptions.returnEnabled() != null) {
                    request.addParameter("IndexField.DoubleOptions.ReturnEnabled", StringUtils.fromBoolean((Boolean)doubleOptions.returnEnabled()));
                }
                if (doubleOptions.sortEnabled() != null) {
                    request.addParameter("IndexField.DoubleOptions.SortEnabled", StringUtils.fromBoolean((Boolean)doubleOptions.sortEnabled()));
                }
            }
            if ((literalOptions = indexField.literalOptions()) != null) {
                if (literalOptions.defaultValue() != null) {
                    request.addParameter("IndexField.LiteralOptions.DefaultValue", StringUtils.fromString((String)literalOptions.defaultValue()));
                }
                if (literalOptions.sourceField() != null) {
                    request.addParameter("IndexField.LiteralOptions.SourceField", StringUtils.fromString((String)literalOptions.sourceField()));
                }
                if (literalOptions.facetEnabled() != null) {
                    request.addParameter("IndexField.LiteralOptions.FacetEnabled", StringUtils.fromBoolean((Boolean)literalOptions.facetEnabled()));
                }
                if (literalOptions.searchEnabled() != null) {
                    request.addParameter("IndexField.LiteralOptions.SearchEnabled", StringUtils.fromBoolean((Boolean)literalOptions.searchEnabled()));
                }
                if (literalOptions.returnEnabled() != null) {
                    request.addParameter("IndexField.LiteralOptions.ReturnEnabled", StringUtils.fromBoolean((Boolean)literalOptions.returnEnabled()));
                }
                if (literalOptions.sortEnabled() != null) {
                    request.addParameter("IndexField.LiteralOptions.SortEnabled", StringUtils.fromBoolean((Boolean)literalOptions.sortEnabled()));
                }
            }
            if ((textOptions = indexField.textOptions()) != null) {
                if (textOptions.defaultValue() != null) {
                    request.addParameter("IndexField.TextOptions.DefaultValue", StringUtils.fromString((String)textOptions.defaultValue()));
                }
                if (textOptions.sourceField() != null) {
                    request.addParameter("IndexField.TextOptions.SourceField", StringUtils.fromString((String)textOptions.sourceField()));
                }
                if (textOptions.returnEnabled() != null) {
                    request.addParameter("IndexField.TextOptions.ReturnEnabled", StringUtils.fromBoolean((Boolean)textOptions.returnEnabled()));
                }
                if (textOptions.sortEnabled() != null) {
                    request.addParameter("IndexField.TextOptions.SortEnabled", StringUtils.fromBoolean((Boolean)textOptions.sortEnabled()));
                }
                if (textOptions.highlightEnabled() != null) {
                    request.addParameter("IndexField.TextOptions.HighlightEnabled", StringUtils.fromBoolean((Boolean)textOptions.highlightEnabled()));
                }
                if (textOptions.analysisScheme() != null) {
                    request.addParameter("IndexField.TextOptions.AnalysisScheme", StringUtils.fromString((String)textOptions.analysisScheme()));
                }
            }
            if ((dateOptions = indexField.dateOptions()) != null) {
                if (dateOptions.defaultValue() != null) {
                    request.addParameter("IndexField.DateOptions.DefaultValue", StringUtils.fromString((String)dateOptions.defaultValue()));
                }
                if (dateOptions.sourceField() != null) {
                    request.addParameter("IndexField.DateOptions.SourceField", StringUtils.fromString((String)dateOptions.sourceField()));
                }
                if (dateOptions.facetEnabled() != null) {
                    request.addParameter("IndexField.DateOptions.FacetEnabled", StringUtils.fromBoolean((Boolean)dateOptions.facetEnabled()));
                }
                if (dateOptions.searchEnabled() != null) {
                    request.addParameter("IndexField.DateOptions.SearchEnabled", StringUtils.fromBoolean((Boolean)dateOptions.searchEnabled()));
                }
                if (dateOptions.returnEnabled() != null) {
                    request.addParameter("IndexField.DateOptions.ReturnEnabled", StringUtils.fromBoolean((Boolean)dateOptions.returnEnabled()));
                }
                if (dateOptions.sortEnabled() != null) {
                    request.addParameter("IndexField.DateOptions.SortEnabled", StringUtils.fromBoolean((Boolean)dateOptions.sortEnabled()));
                }
            }
            if ((latLonOptions = indexField.latLonOptions()) != null) {
                if (latLonOptions.defaultValue() != null) {
                    request.addParameter("IndexField.LatLonOptions.DefaultValue", StringUtils.fromString((String)latLonOptions.defaultValue()));
                }
                if (latLonOptions.sourceField() != null) {
                    request.addParameter("IndexField.LatLonOptions.SourceField", StringUtils.fromString((String)latLonOptions.sourceField()));
                }
                if (latLonOptions.facetEnabled() != null) {
                    request.addParameter("IndexField.LatLonOptions.FacetEnabled", StringUtils.fromBoolean((Boolean)latLonOptions.facetEnabled()));
                }
                if (latLonOptions.searchEnabled() != null) {
                    request.addParameter("IndexField.LatLonOptions.SearchEnabled", StringUtils.fromBoolean((Boolean)latLonOptions.searchEnabled()));
                }
                if (latLonOptions.returnEnabled() != null) {
                    request.addParameter("IndexField.LatLonOptions.ReturnEnabled", StringUtils.fromBoolean((Boolean)latLonOptions.returnEnabled()));
                }
                if (latLonOptions.sortEnabled() != null) {
                    request.addParameter("IndexField.LatLonOptions.SortEnabled", StringUtils.fromBoolean((Boolean)latLonOptions.sortEnabled()));
                }
            }
            if ((intArrayOptions = indexField.intArrayOptions()) != null) {
                if (intArrayOptions.defaultValue() != null) {
                    request.addParameter("IndexField.IntArrayOptions.DefaultValue", StringUtils.fromLong((Long)intArrayOptions.defaultValue()));
                }
                if (intArrayOptions.sourceFields() != null) {
                    request.addParameter("IndexField.IntArrayOptions.SourceFields", StringUtils.fromString((String)intArrayOptions.sourceFields()));
                }
                if (intArrayOptions.facetEnabled() != null) {
                    request.addParameter("IndexField.IntArrayOptions.FacetEnabled", StringUtils.fromBoolean((Boolean)intArrayOptions.facetEnabled()));
                }
                if (intArrayOptions.searchEnabled() != null) {
                    request.addParameter("IndexField.IntArrayOptions.SearchEnabled", StringUtils.fromBoolean((Boolean)intArrayOptions.searchEnabled()));
                }
                if (intArrayOptions.returnEnabled() != null) {
                    request.addParameter("IndexField.IntArrayOptions.ReturnEnabled", StringUtils.fromBoolean((Boolean)intArrayOptions.returnEnabled()));
                }
            }
            if ((doubleArrayOptions = indexField.doubleArrayOptions()) != null) {
                if (doubleArrayOptions.defaultValue() != null) {
                    request.addParameter("IndexField.DoubleArrayOptions.DefaultValue", StringUtils.fromDouble((Double)doubleArrayOptions.defaultValue()));
                }
                if (doubleArrayOptions.sourceFields() != null) {
                    request.addParameter("IndexField.DoubleArrayOptions.SourceFields", StringUtils.fromString((String)doubleArrayOptions.sourceFields()));
                }
                if (doubleArrayOptions.facetEnabled() != null) {
                    request.addParameter("IndexField.DoubleArrayOptions.FacetEnabled", StringUtils.fromBoolean((Boolean)doubleArrayOptions.facetEnabled()));
                }
                if (doubleArrayOptions.searchEnabled() != null) {
                    request.addParameter("IndexField.DoubleArrayOptions.SearchEnabled", StringUtils.fromBoolean((Boolean)doubleArrayOptions.searchEnabled()));
                }
                if (doubleArrayOptions.returnEnabled() != null) {
                    request.addParameter("IndexField.DoubleArrayOptions.ReturnEnabled", StringUtils.fromBoolean((Boolean)doubleArrayOptions.returnEnabled()));
                }
            }
            if ((literalArrayOptions = indexField.literalArrayOptions()) != null) {
                if (literalArrayOptions.defaultValue() != null) {
                    request.addParameter("IndexField.LiteralArrayOptions.DefaultValue", StringUtils.fromString((String)literalArrayOptions.defaultValue()));
                }
                if (literalArrayOptions.sourceFields() != null) {
                    request.addParameter("IndexField.LiteralArrayOptions.SourceFields", StringUtils.fromString((String)literalArrayOptions.sourceFields()));
                }
                if (literalArrayOptions.facetEnabled() != null) {
                    request.addParameter("IndexField.LiteralArrayOptions.FacetEnabled", StringUtils.fromBoolean((Boolean)literalArrayOptions.facetEnabled()));
                }
                if (literalArrayOptions.searchEnabled() != null) {
                    request.addParameter("IndexField.LiteralArrayOptions.SearchEnabled", StringUtils.fromBoolean((Boolean)literalArrayOptions.searchEnabled()));
                }
                if (literalArrayOptions.returnEnabled() != null) {
                    request.addParameter("IndexField.LiteralArrayOptions.ReturnEnabled", StringUtils.fromBoolean((Boolean)literalArrayOptions.returnEnabled()));
                }
            }
            if ((textArrayOptions = indexField.textArrayOptions()) != null) {
                if (textArrayOptions.defaultValue() != null) {
                    request.addParameter("IndexField.TextArrayOptions.DefaultValue", StringUtils.fromString((String)textArrayOptions.defaultValue()));
                }
                if (textArrayOptions.sourceFields() != null) {
                    request.addParameter("IndexField.TextArrayOptions.SourceFields", StringUtils.fromString((String)textArrayOptions.sourceFields()));
                }
                if (textArrayOptions.returnEnabled() != null) {
                    request.addParameter("IndexField.TextArrayOptions.ReturnEnabled", StringUtils.fromBoolean((Boolean)textArrayOptions.returnEnabled()));
                }
                if (textArrayOptions.highlightEnabled() != null) {
                    request.addParameter("IndexField.TextArrayOptions.HighlightEnabled", StringUtils.fromBoolean((Boolean)textArrayOptions.highlightEnabled()));
                }
                if (textArrayOptions.analysisScheme() != null) {
                    request.addParameter("IndexField.TextArrayOptions.AnalysisScheme", StringUtils.fromString((String)textArrayOptions.analysisScheme()));
                }
            }
            if ((dateArrayOptions = indexField.dateArrayOptions()) != null) {
                if (dateArrayOptions.defaultValue() != null) {
                    request.addParameter("IndexField.DateArrayOptions.DefaultValue", StringUtils.fromString((String)dateArrayOptions.defaultValue()));
                }
                if (dateArrayOptions.sourceFields() != null) {
                    request.addParameter("IndexField.DateArrayOptions.SourceFields", StringUtils.fromString((String)dateArrayOptions.sourceFields()));
                }
                if (dateArrayOptions.facetEnabled() != null) {
                    request.addParameter("IndexField.DateArrayOptions.FacetEnabled", StringUtils.fromBoolean((Boolean)dateArrayOptions.facetEnabled()));
                }
                if (dateArrayOptions.searchEnabled() != null) {
                    request.addParameter("IndexField.DateArrayOptions.SearchEnabled", StringUtils.fromBoolean((Boolean)dateArrayOptions.searchEnabled()));
                }
                if (dateArrayOptions.returnEnabled() != null) {
                    request.addParameter("IndexField.DateArrayOptions.ReturnEnabled", StringUtils.fromBoolean((Boolean)dateArrayOptions.returnEnabled()));
                }
            }
        }
        return request;
    }
}

